//**********************************************************************************************
//		(C) Copyright 2003 by Dipl. Phys. Joerg Plewe, HARDCODE Development
//		All rights reserved. Copying, modification,
//		distribution or publication without the prior written
//		consent of the author is prohibited.
//**********************************************************************************************
package de.jpilot.server;

import de.jpilot.app.server.Server;

/**
 * Just another main method to start the Server class without requesting an 
 * interactive command mode like Server.main() does.
 *
 * @see Server
 * @author  Herkules
 */
public class Service
{
	
    /**
     * @param args the command line arguments
     */
    public static void main(String args[])
    {
		int port = Server.SERVER_DEFAULT_PORT;
		
        if ( args.length == 1 )
        {
            try
            {
                port = Integer.parseInt( args[ 0 ] );
            }
            catch ( NumberFormatException e )
            {
                System.err.println( "Argument " + args[ 0 ] + " isn't a valid port number!" );
            }
        }
		
        Server server = new Server( port );
    }
}
