//**********************************************************************************************
//		(C) Copyright 2002 by Dipl. Phys. Joerg Plewe, HARDCODE Development
//		All rights reserved. Copying, modification,
//		distribution or publication without the prior written
//		consent of the author is prohibited.
//
// Created on 5. Dezember 2002, 23:14
//**********************************************************************************************
package de.jpilot.protocol;

import de.hardcode.hq.location.Locations;
import de.hardcode.hq.property.Properties;
import de.hardcode.hq.registry.Registry;


/**
 * Create a collection of subsystems used by both, client and server.
 *
 * @author  Herkules
 */
public class SubSystems
{
    private final   Registry            mRegistry;
    private final   Locations           mLocations;
    private final   Properties			mProperties;
	
    /**
     * Creates a new instance of SubSystems.
     */
    public SubSystems()
    {
        mRegistry   = new Registry();
        mLocations  = new Locations();
		mProperties	= new Properties();
    }

 
    /**
     * Shutdown subsystems.
     */
    public final void close()
    {
        // SubSystems currently have no shutdown.
    }
    
    
    public final Registry getRegistry()
    {
        return mRegistry;
    }
    
    public final Locations getLocations()
    {
        return mLocations;
    }

	public final Properties getProperties()
    {
        return mProperties;
    }
    
}
