//**********************************************************************************************
//		(C) Copyright 2003 by Dipl. Phys. Joerg Plewe, HARDCODE Development
//		All rights reserved. Copying, modification,
//		distribution or publication without the prior written
//		consent of the author is prohibited.
//**********************************************************************************************
package de.jpilot.protocol;

import de.hardcode.hq.HeadQuarterIdentities;
import de.hardcode.hq.identity.*;

/**
 *
 * @author  Herkules
 */
public class ID
{
	
	//
	// Protocol IDs
	//
	public final static Identity CHAT				= HeadQuarterIdentities.CHAT_ID;
	public final static Identity TIME_SERVICE		= HeadQuarterIdentities.TIME_SERVICE_ID;
	public final static Identity REGISTRY			= HeadQuarterIdentities.REGISTRY_ID;
	public final static Identity REGISTRY_SERVICE	= HeadQuarterIdentities.REGISTRY_SERVICE_ID;
	public final static Identity PROPERTY			= HeadQuarterIdentities.PROPERTY_ID;
	public final static Identity PROPERTY_SERVICE	= HeadQuarterIdentities.PROPERTY_SERVICE_ID;
	public final static Identity LOCATIONS			= HeadQuarterIdentities.LOCATIONS_ID;
	public final static Identity LOCATIONS_SERVICE	= HeadQuarterIdentities.LOCATIONS_SERVICE_ID;
	
	// Events that are transmitted to the server only.
	public final static Identity SERVER_EVENTS		= new ByteIdentity( (byte)1 );

	// Events that are transmitted to the server and distributed to the world.
	public final static Identity PUBLIC_EVENTS		= new ByteIdentity( (byte)2 );
	
	
	//
	// Registry IDs
	//
	
	// ID for the group of players.
	public final static Identity PLAYERS			= new NamedIdentity( "PLAYER" );
	
	//
	// Property IDs
	//
	public final static Identity PLAYER_NAME		= new NamedIdentity( "Name" );
	public final static Identity IS_DEAD			= new ByteIdentity( (byte)1 );
	public final static Identity KILLS				= new ByteIdentity( (byte)2 );
	public final static Identity KILLED				= new ByteIdentity( (byte)3 );
	public final static Identity BOUNTY				= new ByteIdentity( (byte)4 );

	
	//
	// Public event IDs
	//
	public final static Identity BULLET_FIRED		= new ByteIdentity( (byte)1 );
	
	
}
