//**********************************************************************************************
//		(C) Copyright 2003 by Dipl. Phys. Joerg Plewe, HARDCODE Development
//		All rights reserved. Copying, modification,
//		distribution or publication without the prior written
//		consent of the author is prohibited.
//**********************************************************************************************
package de.jpilot.movement;

import de.jpilot.game.MotionData;
import de.hardcode.time.Ticker;

/**
 *
 * @author  Herkules
 */
public class RemoteControlledMovement implements Movement
{
	
	private final	MotionData			mRemotePosition	= new MotionData();
	private final	ConstantMovement	mRemoteMove		= new ConstantMovement();
	
	/**
	 * Creates a new instance of RemoteControlledMovement
	 */
	public RemoteControlledMovement()
	{
	}
	
	
	public void update( Ticker ticker, MotionData data )
	{
		mRemoteMove.update( ticker, mRemotePosition );
		data.set( mRemotePosition );
	}

	
	/**
	 * Notify about the latest, known remote position and when it has been recorded.
	 */
	public void setRemotePosition( MotionData pos )
	{
		mRemotePosition.set( pos );
	}

}
