//**********************************************************************************************
//		(C) Copyright 2003 by Dipl. Phys. Joerg Plewe, HARDCODE Development
//		All rights reserved. Copying, modification,
//		distribution or publication without the prior written
//		consent of the author is prohibited.
//**********************************************************************************************
package de.jpilot.movement;

import de.jpilot.game.Actor;
import de.jpilot.game.ActorHandlerBase;
import de.jpilot.game.MotionData;
import de.hardcode.time.Ticker;

/**
 * Connect an Actor with a Movement.
 *
 * @author  Herkules
 */
public class MovementHandler extends ActorHandlerBase
{
	
	private final Movement			mMovement;
	private final MotionData		mMotionData			= new MotionData();
	
	/**
	 * Creates a new instance of MovementHandler
	 */
	public MovementHandler( Movement movement )
	{
		mMovement = movement;
	}
	
	
	public void update( Actor actor, Ticker ticker )
	{
		// Get current motion data.
		actor.getMotionData( mMotionData );
		
		// Update it.
		mMovement.update( ticker, mMotionData );

		// Update the actor.
		actor.setMotionData( mMotionData );
	}
	
}
