//**********************************************************************************************
//		(C) Copyright 2003 by Dipl. Phys. Joerg Plewe, HARDCODE Development
//		All rights reserved. Copying, modification,
//		distribution or publication without the prior written
//		consent of the author is prohibited.
//**********************************************************************************************
package de.jpilot.movement;

import de.jpilot.game.Actor;
import de.jpilot.game.ActorHandler;
import de.jpilot.game.MotionData;
import de.hardcode.time.Ticker;

/**
 *
 * @author  Herkules
 */
public class CoordinateWrapperHandler implements ActorHandler
{
	private final int mWidth;
	private final int mHeight;
	
	private final MotionData mMotionData	= new MotionData();
	
	/**
	 * Creates a new instance of CoordinateWrapperHandler
	 */
	public CoordinateWrapperHandler( int width, int height )
	{
		mWidth	= width;
		mHeight	= height;
	}
	
	public void close()
	{
	}
	
	
	/**
	 * Implement Handler#update().
	 */
	public void update( Actor actor, Ticker ticker )
	{
		boolean set = false;
		
		actor.getMotionData( mMotionData );

    		
		if ( mMotionData.x > mWidth )
		{
			mMotionData.x = mMotionData.x % mWidth;
			set = true;
		}
		
		if ( mMotionData.y > mHeight )
		{
			mMotionData.y = mMotionData.y % mHeight;
			set = true;
		}
		
		if ( mMotionData.x < 0 )
		{
			mMotionData.x = mWidth + mMotionData.x;
			set = true;
		}
		
		if ( mMotionData.y < 0 )
		{
			mMotionData.y = mHeight + mMotionData.y;
			set = true;
		}
		
		if ( set )
			actor.setMotionData( mMotionData );
	}
	
}
