//**********************************************************************************************
//		(C) Copyright 2003 by Dipl. Phys. Joerg Plewe, HARDCODE Development
//		All rights reserved. Copying, modification,
//		distribution or publication without the prior written
//		consent of the author is prohibited.
//**********************************************************************************************
package de.jpilot.movement;

import de.jpilot.game.MotionData;
import de.hardcode.time.Ticker;

/**
 *
 * @author  Herkules
 */
public class ConstantMovement implements Movement
{
	
	/**
	 * Implement Movement.
	 */
	public void update( Ticker ticker, MotionData data )
	{
		
//		float dt	= ticker.getDeltaT();
		float dt	= (float)( ticker.getTickTime() - data.timestamp ); 
		float dtdt	= dt * dt;
		
		//
		// Takeover the new values.
		//
		data.x		+= data.vx		* dt	+ 0.5f * data.ax * dtdt;
		data.y		+= data.vy		* dt	+ 0.5f * data.ay * dtdt;
		
		data.vx		+= data.ax		* dt;
		data.vy		+= data.ay		* dt;
		
		data.alpha	+= data.omega	* dt;
		
		data.timestamp = ticker.getTickTime();
	}
		
}
