//**********************************************************************************************
//		(C) Copyright 2003 by Dipl. Phys. Joerg Plewe, HARDCODE Development
//		All rights reserved. Copying, modification,
//		distribution or publication without the prior written
//		consent of the author is prohibited.
//**********************************************************************************************
package de.jpilot.hqcontrol;

import de.jpilot.game.Actor;
import de.jpilot.game.ActorHandler;

import de.hardcode.hq.identity.Identity;
import de.hardcode.hq.registry.*;
import de.hardcode.time.Ticker;
import de.jpilot.protocol.ID;

/**
 * Listens to the registry and closes the actor if the entry in the PLAYERS
 * group vanishes.
 *
 * @author  Herkules
 */
public class RemoteRemovedHandler extends RegistryListenerAdapter implements ActorHandler
{
	private final Registry			mRegistry;
	private final Identity			mIdentity;
	private boolean					mDoClose	= false;
	
	/**
	 * Creates a new instance of RemoteRemovedHandler
	 */
	public RemoteRemovedHandler( Registry reg, Identity id )
	{
		mRegistry = reg;
		mIdentity = id;
		
		mRegistry.addListener( this );
	}
	
	public void removedMember( IdentitySet where, Identity what, Object initiator )
	{
		if (	where.getIdentity().isSameAs( ID.PLAYERS )
			&&	what.isSameAs( mIdentity ) )
		{
			// Close actor next update
			mDoClose = true;
			
			// Unregister my from the registry.
			mRegistry.removeListener( this );
		}
	}
	
	
	/**
	 * Implement ActorHandler.
	 */
	public void close()
	{
		// Intentionally empty.
	}
	
	
	/**
	 * Implement ActorHandler.
	 */
	public void update( Actor actor, Ticker ticker )
	{
		if ( mDoClose )
			actor.close();
	}
	
}
