//**********************************************************************************************
//		(C) Copyright 2003 by Dipl. Phys. Joerg Plewe, HARDCODE Development
//		All rights reserved. Copying, modification,
//		distribution or publication without the prior written
//		consent of the author is prohibited.
//**********************************************************************************************
package de.jpilot.hqcontrol;

import de.hardcode.hq.identity.Identity;
import de.hardcode.hq.property.*;
import de.jpilot.game.Actor;
import de.jpilot.game.Ship;
import de.jpilot.game.ShipListener;
import de.jpilot.protocol.ID;

/**
 *
 * @author  Herkules
 */
public class RemotePlayerPropertyMaintainer implements ShipListener
{
	private final Identity		mIdentity;
	private final Properties	mProperties;

	/**
	 * Creates a new instance of RemotePlayerPropertyListener
	 */
	public RemotePlayerPropertyMaintainer(  Identity playerId, Properties props )
	{
		mIdentity		= playerId;
		mProperties		= props;
	}
	
	public void closed( Actor actor )
	{
		// Not interested
	}
	
	
	public void killed( Ship ship, Ship whom )
	{
		PropertySet propset			= mProperties.resolve( mIdentity );
		IntegerValue killvalue		= (IntegerValue)propset.getValue( ID.KILLS );
		IntegerValue bountyvalue	= (IntegerValue)propset.getValue( ID.BOUNTY );

		propset.startUpdate( Initiators.CLIENT );
		
		killvalue.add( 1 );
		bountyvalue.add( whom.getStatistics().getBounty() + 1 );
		
		propset.finishUpdate();
	}
	
	public void moved( Actor actor )
	{
		// Not interested
	}
	
	public void changedStats(de.jpilot.game.Ship ship)
	{
	}
	
	public void damaged(de.jpilot.game.Ship ship, float howmuch, de.jpilot.game.Ship who)
	{
	}
	
	public void died(de.jpilot.game.Ship ship)
	{
	}
		
	public void renamed(de.jpilot.game.Ship ship)
	{
	}
	
	public void spawned(de.jpilot.game.Ship ship)
	{
	}
	
}
