//**********************************************************************************************
//		(C) Copyright 2003 by Dipl. Phys. Joerg Plewe, HARDCODE Development
//		All rights reserved. Copying, modification,
//		distribution or publication without the prior written
//		consent of the author is prohibited.
//**********************************************************************************************
package de.jpilot.hqcontrol;

import de.hardcode.hq.identity.Identity;
import de.hardcode.hq.property.*;
import de.hardcode.hq.property.changes.Change;
import de.hardcode.hq.property.changes.Changes;
import de.hardcode.time.Ticker;
import de.jpilot.game.Actor;
import de.jpilot.game.ActorHandler;
import de.jpilot.game.Ship;
import de.jpilot.protocol.ID;

/**
 *
 * @author  Herkules
 */
public class RemotePlayerPropertyHandler implements PropertyListener, ActorHandler
{
	private final Identity		mIdentity;
	private final Properties	mProperties;
	
	private String mChangeNameTo	= null;
	private Boolean	mIsDeadNow		= null;
	private Integer mKilledStats	= null;
	private Integer mKillsStats		= null;
	private Integer mBounty			= null;
	
	/**
	 * Creates a new instance of RemotePlayerPropertyHandler
	 */
	public RemotePlayerPropertyHandler( Identity playerId, Properties props )
	{
		mIdentity		= playerId;
		mProperties		= props;
		
		mProperties.addListener( this );
	}
	
	
	//
	//
	// Implement PropertyListener
	//
	//
	public void changed( PropertySet which, Object initiator )
	{
		if (	initiator != Initiators.CLIENT  
			&&	which.getIdentity().isSameAs( mIdentity ) )
		{
			Changes changes = which.getChanges();
			int n = changes.getChangeCount();
			
			for ( int i = 0; i < n; i++ )
			{
				Change chg = changes.getChange( i );
				
				if ( chg.getValue().getIdentity().isSameAs( ID.PLAYER_NAME ) )
				{
					mChangeNameTo = ((StringValue)chg.getValue()).get();
				}
				else if ( chg.getValue().getIdentity().isSameAs( ID.IS_DEAD ) )
				{
					mIsDeadNow = Boolean.valueOf( ((BooleanValue)chg.getValue()).get() );
				}
				else if ( chg.getValue().getIdentity().isSameAs( ID.KILLS ) )
				{
					mKillsStats = new Integer( ((IntegerValue)chg.getValue()).get() );
				}
				else if ( chg.getValue().getIdentity().isSameAs( ID.KILLED ) )
				{
					mKilledStats = new Integer( ((IntegerValue)chg.getValue()).get() );
				}
				else if ( chg.getValue().getIdentity().isSameAs( ID.BOUNTY ) )
				{
					mBounty = new Integer( ((IntegerValue)chg.getValue()).get() );
				}
			}
		}
	}
	
	
	public void created( PropertySet which, Object initiator )
	{
		//
		// Intentionally empty.
		// Lifecycle management is not done here.
		//
	}
	
	public void eliminated( PropertySet which, Object initiator )
	{
		//
		// Intentionally empty.
		// Lifecycle management is not done here.
		//
	}

	
	//
	//
	// Implement ActorHandler
	//
	//
	
	
	public void close()
	{
		// When the actor closes, I do not longer have to listen.
		mProperties.removeListener( this );
	}
	
	
	public void update( Actor actor, Ticker ticker)
	{
		Ship ship = (Ship)actor;

		if ( null != mChangeNameTo )
		{
			ship.setName( mChangeNameTo );
		}

		if ( null != mIsDeadNow )
		{
			if ( mIsDeadNow.booleanValue() )
				ship.die();
			else
				ship.spawn();
		}
		
		if ( null != mKillsStats )
		{
			ship.getStatistics().setKills( mKillsStats.intValue() );
		}
		
		if ( null != mKilledStats )
		{
			ship.getStatistics().setKilled( mKilledStats.intValue() );
		}

		if ( null != mBounty )
		{
			ship.getStatistics().setBounty( mBounty.intValue() );
		}
		
		mChangeNameTo	= null;
		mIsDeadNow		= null;	
		mKillsStats		= null;	
		mKilledStats	= null;	
		mBounty			= null;
	}
	
}
