//**********************************************************************************************
//		(C) Copyright 2003 by Dipl. Phys. Joerg Plewe, HARDCODE Development
//		All rights reserved. Copying, modification,
//		distribution or publication without the prior written
//		consent of the author is prohibited.
//**********************************************************************************************
package de.jpilot.hqcontrol;

import de.hardcode.hq.identity.Identity;
import de.hardcode.hq.location.Location;
import de.hardcode.hq.location.LocationData;
import de.hardcode.hq.location.LocationListener;
import de.hardcode.hq.location.Locations;
import de.hardcode.time.Ticker;
import de.jpilot.game.Actor;
import de.jpilot.game.ActorHandler;
import de.jpilot.game.MotionData;
import javax.vecmath.Vector3f;

/**
 *
 * @author  Herkules
 */
public class RemoteMovedHandler implements LocationListener, ActorHandler
{
	private final Locations			mLocations;
	private final Identity			mIdentity;
	
	private final Vector3f			LOOK_MINUS_Z	= new Vector3f( 0f, 0f, -1f );
	private final LocationData		mLastKnown		= new LocationData();

	private final MotionData		mActorPos		= new MotionData();

	/**
	 * Creates a new instance of RemoteMovedHandler
	 */
	public RemoteMovedHandler( Locations locations, Identity id )
	{
		mLocations	= locations;
		mIdentity	= id;
		
		mLocations.addListener( this );
	}
	
	//
	//
	// Implement ActorHandler.
	//
	//
	
	/**
	 * Called when an actor is closed.
	 */
	public void close()
	{
		
		// When the actor is closed, remove the listener.
		mLocations.removeListener( this );
	}
	
	
	public void update( Actor actor, Ticker ticker )
	{
		//
		// Convert location data to MotionData
		//

		LocationData data = mLastKnown;

		Vector3f trans = new Vector3f();
		data.position().get( trans );

		LOOK_MINUS_Z.x = 0.0f;
		LOOK_MINUS_Z.y = 0.0f;
		LOOK_MINUS_Z.z = -1.0f;
		data.position().transform( LOOK_MINUS_Z );

		double alpha = Math.atan2( LOOK_MINUS_Z.x, LOOK_MINUS_Z.z ) - Math.PI/2.0;

		mActorPos.x = trans.x;
		mActorPos.y = trans.z;	//!

		mActorPos.vx = data.velocity().x;
		mActorPos.vy = data.velocity().z; //!

		mActorPos.ax = data.acceleration().x;
		mActorPos.ay = data.acceleration().z; //!

		mActorPos.alpha = (float)alpha;
		mActorPos.omega = data.spin().y;

		mActorPos.timestamp = data.getTimeStamp();

		actor.setMotionData( mActorPos );
	}
	
	
	//
	//
	// Implement LocationListener.
	//
	//
	
	
	public void changed( Location loc, int what, Object initiator )
	{
		if ( loc.getIdentity().isSameAs( mIdentity ) )
		{
			loc.getData( mLastKnown );
		}
	}
	
	public void created( Location which, Object initiator )
	{
		//
		// Intentionally empty.
		// Lifecycle management is not done here.
		//
	}
	
	public void eliminated( Location which, Object initiator )
	{
		//
		// Intentionally empty.
		// Lifecycle management is not done here.
		//
	}
	
}
