//**********************************************************************************************
//		(C) Copyright 2003 by Dipl. Phys. Joerg Plewe, HARDCODE Development
//		All rights reserved. Copying, modification,
//		distribution or publication without the prior written
//		consent of the author is prohibited.
//**********************************************************************************************
package de.jpilot.hqcontrol;

import de.jpilot.game.*;
import de.jpilot.protocol.ID;

import de.hardcode.hq.identity.Identity;
import de.hardcode.hq.property.*;
import de.hardcode.hq.property.changes.*;

import java.util.Iterator;


/**
 *
 * @author  Herkules
 */
public class PropertyController implements PropertyListener
{
	private final	Game			mGame;
	private final	Properties		mProperties;
	
	/**
	 * Creates a new instance of RegistryControler
	 */
	public PropertyController( Game game, Properties props )
	{
		mGame		= game;
		mProperties	= props;
	
		// Listen to the registry.
		mProperties.addListener( this );

		// Listen to the game.
//		mGame.getEventQueue().addListener( this );
	}
	
	
	/**
	 * Shutdown.
	 */
	public void close()
	{
		Log.logger.info( "Closing PropertyController" );

//		mGame.getEventQueue().removeListener( this );
		mProperties.removeListener( this );
	}
	
	
	/** 
	 * Implement PropertyListener.
	 */
	public void changed( PropertySet which, Object initiator )
	{
		if ( initiator == this )
			return;

		// What changed?
		Changes what = which.getChanges();

		
//		Actor actor = mGame.getActor( which.getIdentity() );
//
//		//
//		// Is this the property of an actor?
//		//
//		if ( null != actor )
//		{
//			for( int i = 0; i < what.getChangeCount(); i++ )
//			{
//				Change	chg = what.getChange( i );
//				Value	val = chg.getValue();
//
//				if ( val.getIdentity().isSameAs( ID.PLAYER_NAME ) )
//				{
//					actor.setName( ((StringValue)val).get() );		
//				}
//				else if ( val.getIdentity().isSameAs( ID.KILLS ) )
//				{
//					Player p = (Player)actor;
//					p.getStatistics().setKills( ((IntegerValue)val).get() );
//				}
//				else if ( val.getIdentity().isSameAs( ID.KILLED ) )
//				{
//					Player p = (Player)actor;
//					p.getStatistics().setKilled( ((IntegerValue)val).get() );
//				}
//				else if ( val.getIdentity().isSameAs( ID.IS_DEAD ) )
//				{
//					Player p = (Player)actor;
//					if ( ((BooleanValue)val).get() )
//						p.die();
//					else
//						p.respawn();
//				}
//			}
//		}
		
		// Find the corresponding actor
//		Actor a = mGame.getActor( which.getIdentity() );
//		StringValue name = (StringValue)which.getValue( ID.PLAYER_NAME );
//		a.setName( name.get() );
//		
//		if ( a instanceof Player )
//		{
//			Player p = (Player)a;
//
//			IntegerValue kills	= (IntegerValue)which.getValue( ID.KILLS );
//			IntegerValue killed = (IntegerValue)which.getValue( ID.KILLED );
//			BooleanValue isdead	= (BooleanValue)which.getValue( ID.IS_DEAD );
//
//			p.getStatistics().setKills( kills.get() );
//			p.getStatistics().setKilled( killed.get() );
//		}
		
	}	
	
	
	/** 
	 * Implement PropertyListener.
	 */
	public void created(PropertySet which, Object initiator)
	{
	}	
	
	/** 
	 * Implement PropertyListener.
	 */
	public void eliminated(PropertySet which, Object initiator)
	{
	}
	

	/**
	 * Implement EventQueueListener.
	 */
	public void eval( )
	{
//		Iterator evts = queue.iterator();
//		
//		while ( evts.hasNext() )
//		{
//			Event evt = (Event)evts.next();
//			
//			if ( evt instanceof NewActor )
//			{
//				Actor actor = ((NewActor)evt).getActor();
//				if ( actor instanceof LocalPlayer )
//				{
//					Log.logger.info( "Creating a local players properties with ID " + ((LocalPlayer)actor).getIdentity() );
//					PropertySet propset = mProperties.createPropertySet( ((LocalPlayer)actor).getIdentity(), this );
//
//					propset.startUpdate( this );
//
//					StringValue nameval		= new StringValue(  propset, ID.PLAYER_NAME		);
//					IntegerValue killsval	= new IntegerValue( propset, ID.KILLS			);
//					IntegerValue killedval	= new IntegerValue( propset, ID.KILLED			);	
//					BooleanValue isdeadval	= new BooleanValue( propset, ID.IS_DEAD			);
//
//					nameval.set( actor.getName() );
//
////					killsval.set( 0 );
////					killedval.set( 0 );
//					
//					propset.finishUpdate();
//					
//				}
//			}
//			else if ( evt instanceof ActorRemoved )
//			{
//				Actor actor = ((ActorRemoved)evt).getActor();
//				if ( actor instanceof LocalPlayer )
//				{
//					Log.logger.info( "Removing a local players properties with ID " + ((LocalPlayer)actor).getIdentity() );
//					mProperties.eliminate( mProperties.resolve( ((LocalPlayer)actor).getIdentity() ), this );
//				}
//			}			
//			else if ( evt instanceof ActorRenamed )
//			{
//				Actor actor = ((ActorRenamed)evt).getActor();
//				if ( actor instanceof LocalPlayer )
//				{
//					PropertySet props = mProperties.resolve( ((LocalPlayer)actor).getIdentity() );
//					if ( null != props )
//					{
//						StringValue name = (StringValue)props.getValue( ID.PLAYER_NAME );
//
//						props.startUpdate( this );
//						name.set( ((ActorRenamed)evt).getName() );
//						props.finishUpdate();					
//					}
//				}
//			}
//			else if ( evt instanceof KillsIncreased )
//			{
//				Player player = ((KillsIncreased)evt).getPlayer();
//				PropertySet props = mProperties.resolve( player.getIdentity() );
//
//				IntegerValue kills	= (IntegerValue)props.getValue( ID.KILLS );
//					
//				props.startUpdate( this );
//				kills.add( 1 );
//				props.finishUpdate();					
//			}
//			else if ( evt instanceof KilledIncreased )
//			{
//				Player player = ((KilledIncreased)evt).getPlayer();
//				PropertySet props = mProperties.resolve( player.getIdentity() );
//
//				IntegerValue killed	= (IntegerValue)props.getValue( ID.KILLED );
//					
//				props.startUpdate( this );
//				killed.add( 1 );
//				props.finishUpdate();					
//			}
//			else if ( evt instanceof PlayerDied )
//			{
//				Player player = ((PlayerDied)evt).getPlayer();
//				PropertySet props = mProperties.resolve( player.getIdentity() );
//
//				BooleanValue isdead	= (BooleanValue)props.getValue( ID.IS_DEAD );
//					
//				props.startUpdate( this );
//				isdead.set( true );
//				props.finishUpdate();					
//			}
//			else if ( evt instanceof PlayerRespawned )
//			{
//				Player player = ((PlayerRespawned)evt).getPlayer();
//				PropertySet props = mProperties.resolve( player.getIdentity() );
//
//				BooleanValue isdead	= (BooleanValue)props.getValue( ID.IS_DEAD );
//					
//				props.startUpdate( this );
//				isdead.set( false );
//				props.finishUpdate();					
//			}
//
//		}
	}
	
	
	
}
