//**********************************************************************************************
//		(C) Copyright 2003 by Dipl. Phys. Joerg Plewe, HARDCODE Development
//		All rights reserved. Copying, modification,
//		distribution or publication without the prior written
//		consent of the author is prohibited.
//**********************************************************************************************
package de.jpilot.hqcontrol;

import de.hardcode.hq.identity.Identity;
import de.hardcode.hq.registry.Registry;
import de.jpilot.game.Actor;
import de.jpilot.game.ActorListener;
import de.jpilot.protocol.ID;

/**
 *
 * @author  Herkules
 */
public class LocalPlayerRegistryMaintainer implements ActorListener
{
	private final Identity mIdentity;
	private final Registry mRegistry;

	/**
	 * Creates a new instance of LocalPlayerRegistryMaintainer
	 */
	public LocalPlayerRegistryMaintainer( Identity playerId, Registry reg )
	{
		mIdentity = playerId;
		mRegistry = reg;
		
		mRegistry.resolve( ID.PLAYERS ).add( mIdentity, Initiators.CLIENT );
	}
	
	
	public void closed( Actor actor )
	{
		mRegistry.resolve( ID.PLAYERS ).remove( mIdentity, Initiators.CLIENT );
	}
	
	public void moved( Actor actor )
	{
		// I don't care...
	}
	
	public void killed(Actor actor, Actor whom)
	{
	}	
	
}
