//**********************************************************************************************
//		(C) Copyright 2003 by Dipl. Phys. Joerg Plewe, HARDCODE Development
//		All rights reserved. Copying, modification,
//		distribution or publication without the prior written
//		consent of the author is prohibited.
//**********************************************************************************************
package de.jpilot.hqcontrol;

import de.hardcode.hq.identity.Identity;
import de.hardcode.hq.property.*;
import de.jpilot.game.Actor;
import de.jpilot.game.Ship;
import de.jpilot.game.ShipListener;
import de.jpilot.protocol.ID;

/**
 *
 * @author  Herkules
 */
public class LocalPlayerPropertyMaintainer implements ShipListener
{
	private final Identity		mIdentity;
	private final Properties	mProperties;
	private final PropertySet	mPropSet;	
	private final StringValue	mNameValue;
	private final BooleanValue	mIsDeadValue;
	private final IntegerValue	mKillsValue;
	private final IntegerValue	mKilledValue;
	private final IntegerValue	mBountyValue;
	
	/**
	 * Creates a new instance of LocalPlayerRegistryMaintainer
	 */
	public LocalPlayerPropertyMaintainer( Identity playerId, Properties props )
	{
		mIdentity		= playerId;
		mProperties		= props;
		
		mPropSet = mProperties.createPropertySet( mIdentity, Initiators.CLIENT );

		mPropSet.startUpdate( Initiators.CLIENT );

		mNameValue				= new StringValue(  mPropSet, ID.PLAYER_NAME	);
		mIsDeadValue			= new BooleanValue( mPropSet, ID.IS_DEAD		);
		mKillsValue				= new IntegerValue( mPropSet, ID.KILLS			);
		mKilledValue			= new IntegerValue( mPropSet, ID.KILLED			);	
		mBountyValue			= new IntegerValue( mPropSet, ID.BOUNTY			);	

		mPropSet.finishUpdate();
	}

	
	/**
	 * Implement ShipListener
	 */
	public void closed( Actor actor )
	{
		mProperties.eliminate( mPropSet, this );
	}
	

	/**
	 * Implement ShipListener
	 */
	public void moved( Actor actor )
	{
		// I don't care...
	}
	

	/**
	 * Implement ShipListener
	 */
	public void died( Ship ship )
	{
		mPropSet.startUpdate( Initiators.CLIENT );

		// Not down we are dead now.
		mIsDeadValue.set( true );

		// Increase distributed stats.
		mKilledValue.add( 1 );
				
		// Spread the word.
		mPropSet.finishUpdate();
	}
		

	/**
	 * Implement ShipListener
	 */
	public void spawned( Ship ship )
	{
		mPropSet.startUpdate( Initiators.CLIENT );

		// Set bounty back to 0
		mBountyValue.set( 0 );

		// Set living again
		mIsDeadValue.set( false );
		
		mPropSet.finishUpdate();
	}


	/**
	 * Implement ShipListener
	 */
	public void killed(Ship ship, Ship whom)
	{
	}
	
	/**
	 * Implement ShipListener
	 */
	public void renamed( Ship ship)
	{
		mPropSet.startUpdate( Initiators.CLIENT );
		mNameValue.set( ship.getName() );
		mPropSet.finishUpdate();
	}
	
	
	/**
	 * Implement ShipListener
	 */
	public void damaged(Ship ship, float howmuch, Ship who)
	{
		// No shared property.
	}
	
	/**
	 * Implement ShipListener
	 */
	public void changedStats(Ship ship)
	{
	}

	
	
}
