//**********************************************************************************************
//		(C) Copyright 2003 by Dipl. Phys. Joerg Plewe, HARDCODE Development
//		All rights reserved. Copying, modification,
//		distribution or publication without the prior written
//		consent of the author is prohibited.
//**********************************************************************************************
package de.jpilot.hqcontrol;

import de.hardcode.hq.identity.Identity;
import de.hardcode.hq.location.Location;
import de.hardcode.hq.location.LocationData;
import de.hardcode.hq.location.Locations;
import de.hardcode.hq.location.motion.DeadReckoner;
import de.hardcode.hq.location.motion.EulerMotion;
import de.hardcode.hq.location.motion.Motion;
import de.jpilot.game.Actor;
import de.jpilot.game.ActorListener;
import de.jpilot.game.MotionData;
import javax.vecmath.Vector3f;

/**
 *
 * @author  Herkules
 */
public class DeadReckonListener implements ActorListener
{
	private final Locations mLocations;
	private final Location mLocation;

	private final   LocationData    mLocData        = new LocationData();

	private final   Motion          mRefMotion      = new EulerMotion();
    private final   DeadReckoner    mDeadReckoner   = new DeadReckoner( mRefMotion );
	
	/**
	 * Creates a new instance of DeadReckonListener.
	 */
	public DeadReckonListener(Identity id, Locations locations)
	{
		mLocations = locations;
		mLocation = mLocations.createLocation( id, this );
	}
	
	public void closed( Actor actor )
	{
		mLocations.eliminate( mLocation, this );
	}
	
	
	public void moved( Actor actor )
	{
		final MotionData data = actor.getMotionDataRef();
		
		long currenttime = data.timestamp;
		float deltaT = data.timestamp - mLocData.getTimeStamp();
		
        mLocData.spin().set( 0f, data.omega, 0f );
        mLocData.velocity().set( data.vx, 0f, data.vy ); 
		mLocData.acceleration().set( data.ax, 0f, data.ay ); 

        mLocData.position().setIdentity();
        mLocData.position().rotY( data.alpha - (float)Math.PI/2.0f );
        
        Vector3f trans = new Vector3f( data.x, 0f, data.y );
        mLocData.position().setTranslation( trans );        

        mLocData.setTimeStamp( currenttime );
		
        int what = mDeadReckoner.eval( mLocData, currenttime, deltaT );
        if ( what != Motion.NOTHING )
        {
//			Log.logger.fine( "Deadreckoning wants to send update at " + ticker.getTickTime() );
            mLocation.startUpdate( this );
            mLocation.setData( mLocData, /*what*/ Location.POSITION | Location.SPIN | Location.VELOCITY | Location.ACCELERATION );
            mLocation.finishUpdate( currenttime );
        }		
	}
	
	public void killed(Actor actor, Actor whom)
	{
	}
	
}
