//**********************************************************************************************
//		(C) Copyright 2003 by Dipl. Phys. Joerg Plewe, HARDCODE Development
//		All rights reserved. Copying, modification,
//		distribution or publication without the prior written
//		consent of the author is prohibited.
//**********************************************************************************************
package de.jpilot.hqcontrol;

import de.hardcode.hq.identity.Identity;
import de.hardcode.hq.objectbus.BusTicket;
import de.jpilot.game.Bullet;
import de.jpilot.game.MotionData;
import de.jpilot.protocol.ID;

/**
 *
 * @author  Herkules
 */
public class BulletFiredEvent extends HQPublicEvent
{
	
	/**
	 * Creates a new instance of BulletFiredEvent
	 */
	public BulletFiredEvent()
	{
	}
	
	
	public void set( Bullet bullet, Identity ownerID )
	{
		this.clear();
		this.putID( ID.BULLET_FIRED );
		
		this.putID( ownerID );
		
		MotionData motiondata = bullet.getMotionDataRef();
		
		this.putLong( motiondata.timestamp );
		this.putFloat( motiondata.x );
		this.putFloat( motiondata.y );
		this.putFloat( motiondata.vx );
		this.putFloat( motiondata.vy );
	}
	
	
	/**
	 * Decode an incoming ticket.
	 */
	public static Identity decode( BusTicket t, MotionData data )
	{
//		t.setPosition( 0 );
//		Identity evtid	= t.getID();
		Identity id		= t.getID();
		data.timestamp	= t.getLong();
		data.x			= t.getFloat();
		data.y			= t.getFloat();
		data.vx			= t.getFloat();
		data.vy			= t.getFloat();
		return id;
	}
	
}
