//**********************************************************************************************
//		(C) Copyright 2003 by Dipl. Phys. Joerg Plewe, HARDCODE Development
//		All rights reserved. Copying, modification,
//		distribution or publication without the prior written
//		consent of the author is prohibited.
//**********************************************************************************************
package de.jpilot.graphicsengine.piccolo;

import de.hardcode.time.*;
import edu.umd.cs.piccolo.activities.PActivity;
import edu.umd.cs.piccolo.util.PUtil;

/**
 *
 * @author  Herkules
 */
public class TickingActivity extends PActivity implements Ticking
{
	private final	Clock		mClock		= HiResClock.isAvailable() ? (Clock)new HiResClock() : (Clock)new SystemClock();
	private final	Ticker		mTicker		= new Ticker();
	private			boolean		mDoTick		= false;
	
	/**
	 * Creates a new instance of TickingActivity
	 */
	public TickingActivity()
	{
		super( -1, PUtil.DEFAULT_ACTIVITY_STEP_RATE );
	}
	
	
	public Clock getClock()
	{
		return mClock;
	}
	
	public Ticker getTicker()
	{
		return mTicker;
	}
	
	public void startTicking()
	{
		mDoTick = true;
	}
	
	public synchronized void stopTicking()
	{
		mDoTick = false;
	}
	
	
	protected void activityStep( long elapsedTime ) 
	{
		super.activityStep( elapsedTime );
		
		if ( mDoTick )
		{
			getTicker().tick( getClock().getCurrentTime() );
		}
	}
}
