//**********************************************************************************************
//		(C) Copyright 2003 by Dipl. Phys. Joerg Plewe, HARDCODE Development
//		All rights reserved. Copying, modification,
//		distribution or publication without the prior written
//		consent of the author is prohibited.
//**********************************************************************************************
package de.jpilot.graphicsengine.piccolo;

import de.jpilot.graphicsengine.*;
import edu.umd.cs.piccolo.PNode;

/**
 *
 * @author  Herkules
 */
abstract class StdGraphicObject implements GraphicObject
{
	private final PNode mContainerNode;
	private final PNode mStdContent;
	private boolean		mIsClosed = false;

	
	/**
	 * Creates a new instance of StdGraphicObject
	 */
	public StdGraphicObject( PNode container, PNode content )
	{
		mContainerNode	= container;
		mStdContent		= content; 
		mContainerNode.addChild( mStdContent );
	}
	

	public boolean isClosed()
	{
		return mIsClosed;
	}
	
	/**
	 * Shutdown.
	 */
	public void close()
	{
		if ( isClosed() )
			return;
		
		mIsClosed = true;
		mContainerNode.removeChild( mStdContent );
	}
	
	
	/**
	 * Implement GraphicObject.
	 */
	public void move( float x, float y, float alpha )
	{
		mStdContent.setRotation( alpha );
		mStdContent.setOffset( x, y );
	}	


	/**
	 * Implement GraphicObject.
	 */
	public void setName(String name)
	{
		// Intentionally empty.
	}	


	/**
	 * Implement GraphicObject.
	 */
	public void setVisible( boolean visibility )
	{
		getStdContent().setVisible( visibility );
	}
	
	
	/**
	 * Give access to the container to use.
	 */
	PNode getContainerNode()
	{
		return mContainerNode;
	}


	/**
	 * Give access to the standard Piccolo node to use.
	 */
	PNode getStdContent()
	{
		return mStdContent;
	}
		
	
}
