//**********************************************************************************************
//		(C) Copyright 2002 by Dipl. Phys. Joerg Plewe, HARDCODE Development
//		All rights reserved. Copying, modification,
//		distribution or publication without the prior written
//		consent of the author is prohibited.
//
// Created on 22. November 2002, 21:54
//**********************************************************************************************
package de.jpilot.graphicsengine.piccolo;

import de.hardcode.hq.location.Location;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.activities.PActivity;
import edu.umd.cs.piccolo.util.PPaintContext;
import java.awt.Color;

import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import javax.vecmath.Matrix4f;
import javax.vecmath.Vector3f;

/**
 *
 * @author  Herkules
 */
public class ShipNode extends PNode
{
    public final static Color COLOR	= Color.GREEN;
	
    /**
     * Creates a new instance of LocationNode.
     */
    public ShipNode()
    {
        this.setBounds( -4, -4, 12, 8 );
        this.setPaint( COLOR );   
    }
        
    /**
     * Overload of <code>PNode#paint()</code>.
     */
    protected void paint( PPaintContext paintContext )
    {
        Graphics2D g2 = paintContext.getGraphics();
        
        g2.setPaint( this.getPaint() );
        
        g2.drawOval( -3, -3, 6, 6 );
        g2.drawLine( 3, 0, 7, 0 );
    }
    
}
