//**********************************************************************************************
//		(C) Copyright 2003 by Dipl. Phys. Joerg Plewe, HARDCODE Development
//		All rights reserved. Copying, modification,
//		distribution or publication without the prior written
//		consent of the author is prohibited.
//**********************************************************************************************
package de.jpilot.graphicsengine.piccolo;

import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PText;
import java.awt.Color;

/**
 *
 * @author  Herkules
 */
class Ship extends StdGraphicObject
{
	private final PNode		mGroup;
	private final ShipNode	mShipNode	= new ShipNode();
	private final PText		mName		= new PText( "<unnamed>" );

	
	/**
	 * Creates a new instance of Ship
	 */
	public Ship( PNode node )
	{
		super( node, new PNode() );
		mGroup = getStdContent();
		
		mName.setOffset( -20, +8 );
		mName.setTextPaint( ShipNode.COLOR );
		mGroup.addChild( mShipNode );
		mGroup.addChild( mName );
	}


	public void move( float x, float y, float alpha )
	{
		
		// The whole group only moves
		super.move( x, y, 0 );
		
		// The Ship only rotates.
		mShipNode.setRotation( alpha );
	}	
	
	
	/** 
	 * Change the name.
	 */
	public void setName( String name )
	{
		mName.setText( name );
	}
	
}
