//**********************************************************************************************
//		(C) Copyright 2003 by Dipl. Phys. Joerg Plewe, HARDCODE Development
//		All rights reserved. Copying, modification,
//		distribution or publication without the prior written
//		consent of the author is prohibited.
//**********************************************************************************************
package de.jpilot.graphicsengine.piccolo;

import de.hardcode.hq.chat.client.ChatClient;
import de.hardcode.time.Ticking;
import de.jpilot.graphicsengine.*;
import edu.umd.cs.piccolo.PCanvas;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.util.PDebug;
import edu.umd.cs.piccolo.util.PPaintContext;
import java.awt.*;
import java.awt.Graphics;
import java.util.HashMap;

/**
 *
 * @author  Herkules
 */
public class PiccoloEngine extends PCanvas implements Engine
{
	private final	Console				mConsole	= new Console( 5 );
	private			InputLine			mInputLine;
	private final	TickingActivity		mTicking	= new TickingActivity();
	
	/**
	 * Creates a new instance of Engine
	 */
	public PiccoloEngine( int width, int height )
	{
		super();
		new GridLayer( this );

		this.setPreferredSize( new Dimension( width, height ) );
        this.setBackground( Color.GREEN.darker().darker() );
		//this.setDefaultRenderQuality( PPaintContext.LOW_QUALITY_RENDERING );

		this.setInteractingRenderQuality(	PPaintContext.HIGH_QUALITY_RENDERING );
		this.setAnimatingRenderQuality(		PPaintContext.HIGH_QUALITY_RENDERING );
		this.setDefaultRenderQuality(		PPaintContext.HIGH_QUALITY_RENDERING );

	
		//
		// Configure PCanvas to be non-interactiv.
		//
		this.removeInputEventListener( this.getPanEventHandler() );
		this.removeInputEventListener( this.getZoomEventHandler() );
		
		mConsole.setOffset( 5, height - mConsole.getBoundsReference().getHeight() - 20 );
		this.getCamera().addChild( mConsole );
		
		this.getRoot().addActivity( mTicking );
		
	}

	
	/**
	 * Create a mean to handle chats.
	 */
	public void createChatInput( String playername, ChatClient chatclient )
	{
		mInputLine = new InputLine( this, playername, chatclient, mConsole );
	}
	
	
	public Ticking getTicking()
	{
		return mTicking;
	}
	
	
	/**
	 * Implement Engine.
	 */
	public void render()
	{
//		this.getRoot().validateFullPaint();
	}

	
	public GraphicObject createGraphicObject( int type )
	{
		GraphicObject n;
		if ( type == Engine.TYPE_SHIP )
			n = new Ship( this.getLayer() );
		else // if ( type == Engine.TYPE_BULLET )
			n = new Bullet( this.getLayer() );

		return n;		
	}
	

	/**
	 * Implement Engine.
	 */
	public void logMessage(String message)
	{
		mConsole.logMessage( message );
	}	
	

	/**
	 * Implement Engine.
	 */
	public void showBulletExplosion( double x, double y, double radius )
	{
		BulletDetonationNode b = new BulletDetonationNode( x, y, radius );
		this.getCamera().addChild( b );
		b.activate();		
	}	
	
	
	/**
	 * Deliver a implementation of the Controller interface.
	 */
    public PiccoloController createController()
    {
        PiccoloController c = new PiccoloController();
  		this.addInputEventListener( c );
		this.getRoot().getDefaultInputManager().setKeyboardFocus( c );
		return c;
    }
	
}
