//**********************************************************************************************
//		(C) Copyright 2002 by Dipl. Phys. Joerg Plewe, HARDCODE Development
//		All rights reserved. Copying, modification,
//		distribution or publication without the prior written
//		consent of the author is prohibited.
//
// Created on 23. November 2002, 01:13
//**********************************************************************************************
package de.jpilot.graphicsengine.piccolo;

import de.jpilot.graphicsengine.Controller;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import java.awt.event.KeyEvent;

/**
 *
 * @author  Herkules
 */
public class PiccoloController extends PBasicInputEventHandler implements Controller
{
    private         float         mThrust		= 0.0f;
    private         float         mSteer		= 0.0f;
    private         boolean       mIsFiring		= false;
    
	
	
    /**
     * Creates a new instance of Controller.
	 * Can only be created by the PiccoloEngine.
     */
    PiccoloController()
    {
        super();
                
        this.getEventFilter().rejectAllEventTypes();
        this.getEventFilter().setAcceptsKeyPressed( true );
        this.getEventFilter().setAcceptsKeyReleased( true );
    }
    
	public void keyPressed(PInputEvent event) 
    {
        if ( event.getKeyCode() == KeyEvent.VK_UP )
        {
            mThrust = 1.0f;
        }        
        else if ( event.getKeyCode() == KeyEvent.VK_DOWN )
        {
            mThrust = -1.0f;
        }
        else if ( event.getKeyCode() == KeyEvent.VK_LEFT )
        {
            mSteer =	1.0f;
        }
        else if ( event.getKeyCode() == KeyEvent.VK_RIGHT )
        {
            mSteer = -1.0f;
        }
        else if ( event.getKeyCode() == KeyEvent.VK_SPACE )
        {
            mIsFiring = true;
        }

	}

    public void keyReleased(PInputEvent event)
    {
        if (    event.getKeyCode() == KeyEvent.VK_UP 
            ||  event.getKeyCode() == KeyEvent.VK_DOWN )
            mThrust = 0.0f;
		else if (    event.getKeyCode() == KeyEvent.VK_LEFT 
            ||  event.getKeyCode() == KeyEvent.VK_RIGHT )
            mSteer = 0.0f;
		else if (    event.getKeyCode() == KeyEvent.VK_SPACE )
			mIsFiring = false;
    }

	
	public float getSteer()
	{
		return mSteer;
	}
	
	public float getThrust()
	{
		return mThrust;
	}
	
	public boolean isFiring()
	{
		return mIsFiring;
	}
}
