//**********************************************************************************************
//		(C) Copyright 2003 by Dipl. Phys. Joerg Plewe, HARDCODE Development
//		All rights reserved. Copying, modification,
//		distribution or publication without the prior written
//		consent of the author is prohibited.
//**********************************************************************************************
package de.jpilot.graphicsengine.piccolo;

import de.hardcode.hq.chat.client.*;
import edu.umd.cs.piccolo.PCanvas;
import edu.umd.cs.piccolo.PNode;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.*;
import javax.swing.JComponent;
import javax.swing.JTextField;

/**
 *
 * @author  Herkules
 */
public class InputLine implements ChatListener
{
	
	JTextField mText = new JTextField();
	private final Console mConsole;
	private final String mPlayerName;
	
	/**
	 * Creates a new instance of InputLine
	 */
	public InputLine( PCanvas canvas, String playername, final ChatClient chatclient, Console console )
	{
		mPlayerName = playername;
		mConsole = console;
		
		chatclient.addListener( this );
		
		mText.setLocation( 5, 600 - 20 );
		mText.setSize( 795, 20 );
		mText.setBackground( null );
		mText.setOpaque( false );
		mText.setBorder( null );
		mText.setForeground( Color.CYAN );
		
		mText.addActionListener( new ActionListener()
		{
			public void actionPerformed( ActionEvent e )
			{
				String text = mText.getText().trim();
				if ( text.length() > 0 )
				{
					chatclient.send( mPlayerName, text );
					mText.setText( "" );
					
					// Echo to console.
					mConsole.logMessage( mPlayerName + ": " + text );
				}
				mText.getParent().requestFocus();
			}
		} 
		);
		
		canvas.add( mText );
	}
	
	
	
	public void newMessage( ChatMessage msg )
	{
		mConsole.logMessage( msg.getSenderName() + ": " + msg.getMessage() );
	}
	
}
