//**********************************************************************************************
//		(C) Copyright 2003 by Dipl. Phys. Joerg Plewe, HARDCODE Development
//		All rights reserved. Copying, modification,
//		distribution or publication without the prior written
//		consent of the author is prohibited.
//**********************************************************************************************
package de.jpilot.graphicsengine.piccolo;

import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PText;
import java.awt.Color;

/**
 *
 * @author  Herkules
 */
public class Console extends PNode
{
    public final static Color TEXT_COLOR	= Color.GREEN;
	
	private final PText [] mLines;
	private final int	mNumLines;

	/**
	 * Creates a new instance of Console
	 */
	public Console( int numlines )
	{
		mNumLines = numlines;
		mLines = new PText[ numlines ];
		double height = 0.0;
		
		for ( int i = 0; i < numlines; i++ )
		{
			mLines[ i ] = new PText( " " );
			mLines[ i ].setOffset( 0.0, height );
			mLines[ i ].setTextPaint( TEXT_COLOR );
			this.addChild( mLines[ i ] );
			
			height += mLines[ i ].getBoundsReference().getHeight();
		}
		this.setBounds( 0, 0, 50, height );
	}
	

	/**
	 * Utility. Shift up all lines and clear the lowest.
	 */
	void shiftup()
	{
		for ( int i = 0; i < mNumLines-1; i++ )
		{
			mLines[ i ].setText( mLines[ i+1 ].getText() );
		}
		mLines[ mNumLines - 1 ].setText( "" );
	}

	
	/**
	 * Print out a new message.
	 */
	public void logMessage( String message )
	{
		shiftup();
		mLines[ mNumLines - 1 ].setText( message );		
	}
}
