//**********************************************************************************************
//		(C) Copyright 2002 by Dipl. Phys. Joerg Plewe, HARDCODE Development
//		All rights reserved. Copying, modification,
//		distribution or publication without the prior written
//		consent of the author is prohibited.
//
// Created on 22. November 2002, 21:54
//**********************************************************************************************
package de.jpilot.graphicsengine.piccolo;

import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.activities.PActivity;
import edu.umd.cs.piccolo.util.PPaintContext;
import java.awt.Color;

import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import javax.vecmath.Matrix4f;
import javax.vecmath.Vector3f;

/**
 *
 * @author  Herkules
 */
public class BulletNode extends PNode
{
    
    /**
     * Creates a new instance of LocationNode.
     */
    public BulletNode()
    {
        this.setBounds( -4, -4, 8, 8 );
        this.setPaint( Color.YELLOW );   
    }
        
    /**
     * Overload of <code>PNode#paint()</code>.
     */
    protected void paint( PPaintContext paintContext )
    {
        Graphics2D g2 = paintContext.getGraphics();
        
        g2.setPaint( getPaint() );
        
        g2.drawLine( -2, 0, 3, 0 );
        g2.drawLine( 1, -3, 0, 2 );
    }
    
}
