//**********************************************************************************************
//		(C) Copyright 2003 by Dipl. Phys. Joerg Plewe, HARDCODE Development
//		All rights reserved. Copying, modification,
//		distribution or publication without the prior written
//		consent of the author is prohibited.
//**********************************************************************************************
package de.jpilot.graphicsengine.piccolo;

import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.activities.*;
import edu.umd.cs.piccolo.util.*;
import edu.umd.cs.piccolo.util.PPaintContext;
import java.awt.*;

/**
 *
 * @author  Herkules
 */
public class BulletDetonationNode extends PNode
{
	private final double mRadius;
	private double mDone = 0;
	
	/**
	 * Creates a new instance of BulletDetonationNode
	 */
	public BulletDetonationNode( double x, double y, double radius )
	{
		mRadius = radius;
		this.setOffset( x, y );
		

	}
	

	/**
	 * Activate the effect.
	 */
	public void activate()
	{
		setDone( 0.0 );
		PActivity blow = new PActivity( 500 )
		{			
			protected void activityStep( long elapsedTime )
			{
				super.activityStep(elapsedTime);
				
				setDone( (double)elapsedTime / 500.0 );
			}
			
			protected void activityFinished()
			{
				removeFromParent();
			}
			
		};
		
		this.addActivity( blow );		
	}
	

	/**
	 * Say how much of the effect is already done.
	 */
	private void setDone( double done )
	{
		mDone = done;
		double rad = mRadius * done;
		this.setBounds( -rad, -rad, 2*rad, 2*rad );
	}
	
	
	/**
	 * Overload from PNode#paint()
	 */
	public void paint( PPaintContext paintContext )
	{
		int rad = (int)(mRadius * mDone);
		
		Graphics2D g = paintContext.getGraphics();
		
		g.setPaint( new Color( 1.0f, 1.0f-(float)mDone, 0.0f, 1.0f-(float)mDone ) );
		g.fillOval( -rad, -rad, 2*rad, 2*rad );
	}
	
	
	
	
}
