//**********************************************************************************************
//		(C) Copyright 2003 by Dipl. Phys. Joerg Plewe, HARDCODE Development
//		All rights reserved. Copying, modification,
//		distribution or publication without the prior written
//		consent of the author is prohibited.
//**********************************************************************************************
package de.jpilot.graphicsengine;

import de.hardcode.hq.chat.client.ChatClient;

/**
 * The display engine.
 *
 * @author  Herkules
 */
public interface Engine
{
	final static int		TYPE_SHIP		= 0;
	final static int		TYPE_BULLET		= 1;
		
	
	void createChatInput( String playername, ChatClient chatclient );	
	
	/**
	 * The main render trigger.
	 */
	void render();
	
	/** 
	 * Create a GraphicObject of a certain type.
	 */ 
	GraphicObject createGraphicObject( int type );
		
	/**
	 * Log a text message.
	 */
	void logMessage( String message );
	
	/**
	 * Display a bullets explosion.
	 */
	void showBulletExplosion( double x, double y, double radius );
	
}
