//**********************************************************************************************
//		(C) Copyright 2003 by Dipl. Phys. Joerg Plewe, HARDCODE Development
//		All rights reserved. Copying, modification,
//		distribution or publication without the prior written
//		consent of the author is prohibited.
//**********************************************************************************************
package de.jpilot.game;


/**
 *
 * @author  Herkules
 */
public class PlayerStatistics
{
	private int mKilled = 0;
	private int mKills = 0;
	private int mBounty = 0;

	private final Ship				mPlayer;
	
	
	/**
	 * Notifier that notifies about dying.
	 */
	private final Actor.Notifier STATS_CHANGED = new Actor.Notifier()
	{
		public void notify( ActorListener listener )
		{
			if ( listener instanceof ShipListener )
				((ShipListener)listener).changedStats( mPlayer );
		}
	};
	
	
	/**
	 * Creates a new instance of PlayerStatistics
	 */
	public PlayerStatistics( Ship player )
	{
		mPlayer				= player;
	}
	
	
	public int getKills()
	{
		return mKills;
	}
	
	public void setKills( int kills )
	{
		mKills = kills;
		mPlayer.notify( STATS_CHANGED );
	}
	
	public void addKills()
	{
		setKills( mKills + 1 );
	}

	
	public int getKilled()
	{
		return mKilled;
	}
	
	public void setKilled( int killed )
	{
		mKilled = killed;
		mPlayer.notify( STATS_CHANGED );
	}
	
	public void addKilled()
	{
		setKilled( mKilled + 1 );
	}
	

	public int getBounty()
	{
		return mBounty;
	}
	
	public void setBounty( int bounty )
	{
		mBounty = bounty;
		mPlayer.notify( STATS_CHANGED );
	}
	
	public void addBounty( int bounty )
	{
		setBounty( mBounty + bounty );
	}
}
