//**********************************************************************************************
//		(C) Copyright 2003 by Dipl. Phys. Joerg Plewe, HARDCODE Development
//		All rights reserved. Copying, modification,
//		distribution or publication without the prior written
//		consent of the author is prohibited.
//**********************************************************************************************
package de.jpilot.game;

import de.hardcode.time.Ticker;
import java.util.Iterator;

/**
 *
 * @author  Herkules
 */
public class BulletHitHandler extends ActorHandlerBase
{
	private final			float		mHitRadius; //			= 8.0f;
	private final			float		mHitRadiusSquared;

	public	final static	float		DAMAGE_RADIUS	= 30.0f;
	private final static	float		MAX_DAMAGE		= 2.0f;
	
	
	/**
	 * Creates a new instance of BulletHitHandler
	 */
	public BulletHitHandler( float proximity )
	{
		mHitRadius = proximity;
		mHitRadiusSquared = mHitRadius * mHitRadius;
	}
	
	
	public void update( Actor actor, Ticker ticker )
	{
		Game g = actor.getGame();
		Iterator it = g.getActors();
		MotionData mypos = actor.getMotionDataRef();
		
		while ( it.hasNext() )
		{
			Actor otheractor = (Actor)it.next();
			
			if ( otheractor instanceof Ship )
			{
				Ship ship = (Ship)otheractor;
				
				Bullet mybullet = (Bullet)actor;
				
				if ( mybullet.getOwner() != ship )
				{
					MotionData otherpos	= ship.getMotionDataRef();

					float dx = mypos.x - otherpos.x;
					float dy = mypos.y - otherpos.y;

					
					if ( ( dx*dx + dy*dy ) < mHitRadiusSquared )
					{
						mybullet.explode();
						mybullet.close();
						
						//
						// Damage calculation
						//
						float dist = (float)Math.sqrt( (double)(dx*dx + dy*dy) );
						float damage = MAX_DAMAGE * ( (DAMAGE_RADIUS-dist) / DAMAGE_RADIUS );
						if ( damage < 0.0f )
							damage = 0.0f;
						
						ship.damage( damage, mybullet.getOwner() );
					}
				}
			}
		}
	}
}
