//**********************************************************************************************
//		(C) Copyright 2003 by Dipl. Phys. Joerg Plewe, HARDCODE Development
//		All rights reserved. Copying, modification,
//		distribution or publication without the prior written
//		consent of the author is prohibited.
//**********************************************************************************************
package de.jpilot.game;

import de.jpilot.movement.ConstantMovement;
import de.jpilot.movement.Movement;
import de.jpilot.movement.MovementHandler;
import java.util.Iterator;

/**
 *
 * @author  Herkules
 */
public class Bullet extends Actor
{
	private final static long		BULLET_TTL		= 2000L;
	private final static float		BULLET_COST		= 0.7f;
	public	final static float		DAMAGE_RADIUS	= 30.0f;
	private final static float		MAX_DAMAGE		= 2.0f;
	
	private final Ship				mOwner;
	private final long				mStartTime;
	
	/**
	 * Notifier that notifies about explosion.
	 */
	private final Notifier EXPLODED = new Notifier()
	{
		public void notify( ActorListener listener )
		{
			if ( listener instanceof BulletListener )
				((BulletListener)listener).exploded( Bullet.this );
		}
	};
	
	
	/**
	 * Creates a new instance of Bullet
	 */
	public Bullet( Game game, Ship whofired, MotionData initial )
	{
		super( game );
		mOwner		= whofired;
		mStartTime	= initial.timestamp;
				
		setMotionData( initial );
		
		setupHandlers();
	}

	
	/**
	 * Return who fired that bullet.
	 */
	public Ship getOwner()
	{
		return mOwner;
	}
	
	
	/** 
	 * How much energy does this bullet cost?
	 */
	public static float getCost()
	{
		return BULLET_COST;
	}
	
	
	/**
	 * Yes, explode!
	 */
	public void explode()
	{
		notify( EXPLODED );
	}
	
	
	/** 
	 * Initialize handlers.
	 */
	private void setupHandlers()
	{
		Movement		movement	= new ConstantMovement();

		this.addHandler( new MovementHandler( movement ) );
		this.addHandler( new TTLHandler( mStartTime + BULLET_TTL ) );		
	}
		
}
