//**********************************************************************************************
//		(C) Copyright 2003 by Dipl. Phys. Joerg Plewe, HARDCODE Development
//		All rights reserved. Copying, modification,
//		distribution or publication without the prior written
//		consent of the author is prohibited.
//**********************************************************************************************
package de.jpilot.enginecontrol;

import de.jpilot.game.Actor;
import de.jpilot.game.Ship;
import de.jpilot.game.ShipListener;
import de.jpilot.graphicsengine.GraphicObject;

/**
 *
 * @author  Herkules
 */
public class ShipGraphicListener extends GraphicObjectListener implements ShipListener
{
	
	/**
	 * Creates a new instance of ShipGraphicsListener
	 */
	public ShipGraphicListener( GraphicObject graphics )
	{
		super( graphics );
		
		// Invisible by default.
		getGraphicObject().setVisible( false );
	}
	
	
	public void died( Ship ship)
	{
		getGraphicObject().setVisible( false );		
	}
	
	
	public void spawned( Ship ship )
	{
		getGraphicObject().setVisible( true );		
	}

	
	public void killed(Ship ship, Ship whom)
	{
	}
	
	
	public void renamed( Ship ship )
	{
		getGraphicObject().setName( constructName( ship ) );		
	}

	public void damaged(Ship ship, float howmuch, Ship who)
	{
		// No effect now.
	}

	public void changedStats( Ship ship )
	{
		getGraphicObject().setName( constructName( ship ) );		
	}

	
	/**
	 * Overloadable helper.
	 */
	protected String constructName( Ship ship )
	{
		return ship.getName() + " - " + ship.getStatistics().getBounty() + "/" + ship.getStatistics().getKills() + "/" + ship.getStatistics().getKilled();
	}
		
}
