//**********************************************************************************************
//		(C) Copyright 2003 by Dipl. Phys. Joerg Plewe, HARDCODE Development
//		All rights reserved. Copying, modification,
//		distribution or publication without the prior written
//		consent of the author is prohibited.
//**********************************************************************************************
package de.jpilot.enginecontrol;

import de.jpilot.game.*;
import de.jpilot.graphicsengine.*;

/**
 *
 * @author  Herkules
 */
public class GraphicObjectListener implements ActorListener
{
	
	private final GraphicObject		mGraphicObject;
	
	/**
	 * Creates a new instance of GraphicObjectHandler
	 */
	public GraphicObjectListener( GraphicObject graphics )
	{
		mGraphicObject		= graphics;
	}
	
	public void closed( Actor actor )
	{
		// Also shutdown graphics object.
		mGraphicObject.close();
	}	
	
	public void moved( Actor actor )
	{
		MotionData pos = actor.getMotionDataRef();
		mGraphicObject.move( pos.x, pos.y, pos.alpha );
	}	
		
	
	/**
	 * Help derived classes to access the graphics.
	 */
	protected GraphicObject getGraphicObject()
	{
		return mGraphicObject;
	}
	
	public void killed(Actor actor, Actor whom)
	{
	}
	
}
