//**********************************************************************************************
//		(C) Copyright 2003 by Dipl. Phys. Joerg Plewe, HARDCODE Development
//		All rights reserved. Copying, modification,
//		distribution or publication without the prior written
//		consent of the author is prohibited.
//**********************************************************************************************
package de.jpilot.enginecontrol;

import de.jpilot.game.Bullet;
import de.jpilot.game.BulletListener;
import de.jpilot.game.MotionData;
import de.jpilot.graphicsengine.Engine;
import de.jpilot.graphicsengine.GraphicObject;

/**
 *
 * @author  Herkules
 */
public class BulletGraphicListener extends GraphicObjectListener implements BulletListener
{
	private final Engine mEngine;
	
	
	/**
	 * Creates a new instance of ShipGraphicsListener
	 */
	public BulletGraphicListener( Engine engine, GraphicObject graphics )
	{
		super( graphics );
		
		mEngine = engine;
		
		// Visible by default.
		getGraphicObject().setVisible( true );
	}
	
	
	public void exploded( Bullet bullet )
	{
		MotionData pos = bullet.getMotionDataRef();
		
		// Show an explosion
		mEngine.showBulletExplosion( pos.x, pos.y, Bullet.DAMAGE_RADIUS );
	}
	
}
