//**********************************************************************************************
//		(C) Copyright 2002 by Dipl. Phys. Joerg Plewe, HARDCODE Development
//		All rights reserved. Copying, modification,
//		distribution or publication without the prior written
//		consent of the author is prohibited.
//
// Created on 22. Dezember 2002, 12:43
//**********************************************************************************************
package de.jpilot.commands;

import de.hardcode.time.Ticker;
import java.util.ArrayList;

/**
 *
 * @author  Herkules
 */
public class CommandSequence extends Command
{
    private final   ArrayList   mSequence       = new ArrayList();
    private         int         mCurrentIdx     = -1;
    private         Command     mCurrentCmd     = null;
    
    /**
     * Creates a new instance of CommandSequence.
     */
    public CommandSequence()
    {
    }

    
    /** 
     * Overload of <code>Command#execute()</code>.
     */
    public void execute( Ticker ticker )
    {
        while (     null != mCurrentCmd  
                &&  (   mCurrentCmd.getState() == Command.SCHEDULED 
                    ||  mCurrentCmd.getState() == Command.EXECUTING )
              )
        {
            mCurrentCmd.execute( ticker );

            int state = mCurrentCmd.getState();
            switch( state )
            {
                case Command.FINISHED:
                    nextCommand();
                    break;
                case Command.FAILED:
                    Log.logger.fine( "Command failed to execute: " + mCurrentCmd );
                    stop();
                    break;
                default:
                    Log.logger.warning( "Command with illegal state: " + mCurrentCmd );
                    stop();
                    assert( false ); 
                    break;
            }        
        }
    }
    

    /**
     * Overload of <code>Command#reset()</code>.
     */
    protected void reset()
    {
        super.reset();

        if ( ! mSequence.isEmpty() )
        {
            mCurrentIdx = 0;
            mCurrentCmd = (Command)mSequence.get( mCurrentIdx );        
        }        
    }
    
    
    private final void stop()
    {
        mCurrentCmd = null;
        setState( FAILED );
    }
    
    
    private final void nextCommand()
    {
        if ( mCurrentIdx >= mSequence.size() )
        {
            mCurrentIdx = -1;
            mCurrentCmd = null;
        }
        else
        {
            mCurrentIdx++;
            mCurrentCmd = (Command)mSequence.get( mCurrentIdx );
        }
    }
    
    
    public final void add( Command c )
    {
        mSequence.add( c );
    }
    
}
