//**********************************************************************************************
//		(C) Copyright 2002 by Dipl. Phys. Joerg Plewe, HARDCODE Development
//		All rights reserved. Copying, modification,
//		distribution or publication without the prior written
//		consent of the author is prohibited.
//
// Created on 17. Dezember 2002, 12:57
//**********************************************************************************************
package de.jpilot.commands;

import de.hardcode.time.Ticker;
import java.util.ArrayList;

/**
 *
 * @author  Herkules
 */
public class CommandQueue
{
    private final   ArrayList   mCommands   = new ArrayList();
    
    
    /**
     * Creates a new instance of CommandQueue.
     */
    public CommandQueue()
    {
    }
    

    public final synchronized void add( Command c )
    {
        mCommands.add( c );
        c.reset();
    }
    
    
    public final synchronized void update( Ticker ticker )
    {
        int n = mCommands.size();
        for( int i = n-1; i>=0; i-- )
        {
            Command c = (Command)mCommands.get( i );
            
            int state = c.getState();
            
            switch( state )
            {
                case Command.SCHEDULED:
                case Command.EXECUTING:
                    c.execute( ticker );
                    break;
                case Command.FINISHED:
                    mCommands.remove( i );
                    break;
                case Command.FAILED:
                    Log.logger.fine( "Command failed to execute: " + c );
                    mCommands.remove( i );
                    break;
                default:
                    Log.logger.warning( "Command with illegal state: " + c );
                    assert( false ); 
                    break;
            }
        }
    }
    
}
