//**********************************************************************************************
//		(C) Copyright 2002 by Dipl. Phys. Joerg Plewe, HARDCODE Development
//		All rights reserved. Copying, modification,
//		distribution or publication without the prior written
//		consent of the author is prohibited.
//
// Created on 17. Dezember 2002, 12:57
//**********************************************************************************************
package de.jpilot.commands;

import de.hardcode.time.Ticker;

/**
 *
 * @author  Herkules
 */
abstract public class Command
{
    public final static     int     SCHEDULED   = 0;
    public final static     int     FINISHED    = 1;
    public final static     int     EXECUTING   = 2;
    public final static     int     FAILED      = 3;

    public final static     long    NOW         = Long.MIN_VALUE;
    
    protected               int     mState      = SCHEDULED;
    protected               long    mStartTime  = NOW;
    
    
    /**
     * Creates a new instance of Command.
     */
    public Command()
    {
    }
    
    /**
     * Main action. Please overload.
     */
    abstract protected void execute( Ticker ticker );

    
    /**
     * Called by CommandQueue whenever a command is added to it.
     */
    protected void reset()
    {
        mState = SCHEDULED;
    }
    
    
    public final int getState()
    {
        return mState;
    }

    
    /**
     * For internal use: set the state of this command.
     * Typically <code>execute()</code> should call <code>setState(FINISHED)</code>.
     */
    protected final void setState( int state )
    {
        mState = state;
    }
    
    
    
    public final void setStartTime( long when )
    {
        mStartTime = when;       
    }
    
    
    /**
     * Retrieve the time when this command is meant to be executed.
     */
    public final long getStartTime()
    {
        return mStartTime;
    }
    
    
    protected boolean readyToExecute( Ticker ticker )
    {
        return ( getStartTime() < ticker.getTickTime() );
    }
    
}
