//**********************************************************************************************
//		(C) Copyright 2003 by Dipl. Phys. Joerg Plewe, HARDCODE Development
//		All rights reserved. Copying, modification,
//		distribution or publication without the prior written
//		consent of the author is prohibited.
//**********************************************************************************************
package de.jpilot.client;

import de.jpilot.game.MotionData;
import de.jpilot.movement.Movement;
import de.hardcode.time.Ticker;
import de.jpilot.graphicsengine.Controller;

/**
 *
 * @author  Herkules
 */
public class UserControlledMovement implements Movement
{
	private final			Controller	mController;

	
	private final static	float		SCALE_THRUST	= 0.00009f;
	private final static	float		SCALE_ROT		= -0.003f;
    private final static    float       MAX_SPEED       = 0.08f;
	    
	private					float		mAcceleration	= 0.0f;
	private					float		mTurn			= 0.0f;
	
	
	/**
	 * Creates a new instance of UserControlleMovement
	 */
	public UserControlledMovement( Controller controller )
	{
		mController = controller;
	}
	
	private void setAcceleration( float acc )
	{
		mAcceleration = acc;
	}
	
	private void setTurn( float turn )
	{
		mTurn = turn;
	}
	
	
	private void updateFromController()
	{
		this.setAcceleration( mController.getThrust() );
		this.setTurn( mController.getSteer() );
	}
	
	
	/**
	 * Implement Movement.
	 */
	public void update( Ticker ticker, MotionData data )
	{
		
		updateFromController();
		
		float acc	= mAcceleration	* SCALE_THRUST;
		float rot	= mTurn			* SCALE_ROT;
		
//		float dt	= ticker.getDeltaT();
		float dt	= (float)( ticker.getTickTime() - data.timestamp ); 
		
		float alpha = data.alpha;
        alpha += rot * dt;

		float cos = (float)Math.cos( alpha );
		float sin = (float)Math.sin( alpha );
		
        float acc_displ = 0.5f * acc * dt * dt;
        float dx = (data.vx * dt) + acc_displ * cos;
        float dy = (data.vy * dt) + acc_displ * sin;
        
        data.vx += acc * cos * dt;
        data.vy += acc * sin * dt;
		data.ax	= acc * cos;
		data.ay	= acc * sin;

		
        float totalspeed = (float)Math.sqrt( data.vx * data.vx + data.vy * data.vy );
        if ( totalspeed > MAX_SPEED )
        {
            float scale = MAX_SPEED / totalspeed;
            data.vx *= scale;
            data.vy *= scale;

			// No acceleration any more
			data.ax = 0.0f;
			data.ay = 0.0f;
        }

		//
		// Takeover the new values.
		//
		data.x		+= dx;
		data.y		+= dy;
		data.alpha	= alpha;		
		data.omega	= rot;
		data.timestamp = ticker.getTickTime();
		
	}	
}
