//**********************************************************************************************
//		(C) Copyright 2003 by Dipl. Phys. Joerg Plewe, HARDCODE Development
//		All rights reserved. Copying, modification,
//		distribution or publication without the prior written
//		consent of the author is prohibited.
//**********************************************************************************************
package de.jpilot.client;

import de.hardcode.hq.identity.Identity;
import de.hardcode.hq.registry.*;
import de.jpilot.hqcontrol.Initiators;
import de.jpilot.protocol.ID;

/**
 * Simple listener to the registry subsystem that creates a new actor 
 * if an entry appears in the PLAYERS group.
 *
 * @author  Herkules
 */
public class RemotePlayerManager 
{
	private final Client mClt;
	
	private RegistryListener mRegListener = new RegistryListenerAdapter()
	{
		public void addedMember( IdentitySet where, Identity what, Object initiator )
		{
			if (	initiator != Initiators.CLIENT 
				&&	where.getIdentity().isSameAs( ID.PLAYERS ) )
			{
				RemotePlayer.create( mClt, what ); 
			}
		}
	};
	

	/**
	 * Creates a new instance of RemotePlayerManager
	 */
	public RemotePlayerManager( Client clt )
	{
		mClt = clt;
		
		mClt.getSubSystems().getRegistry().addListener( mRegListener );
	}
	

	/** 
	 * Shutdown.
	 */
	public void close()
	{
		mClt.getSubSystems().getRegistry().removeListener( mRegListener );		
	}
	
}
