//**********************************************************************************************
//		(C) Copyright 2003 by Dipl. Phys. Joerg Plewe, HARDCODE Development
//		All rights reserved. Copying, modification,
//		distribution or publication without the prior written
//		consent of the author is prohibited.
//**********************************************************************************************
package de.jpilot.client;

import de.jpilot.hqcontrol.RemotePlayerPropertyMaintainer;
import de.jpilot.enginecontrol.ShipGraphicListener;
import de.jpilot.game.Ship;
import de.jpilot.graphicsengine.Engine;
import de.jpilot.movement.CoordinateWrapperHandler;
import de.jpilot.movement.DebugMovementReporter;
import de.jpilot.movement.MovementHandler;
import de.jpilot.hqcontrol.DeadReckonListener;

import de.hardcode.hq.identity.Identity;
import de.hardcode.hq.identity.NamedIdentity;
import de.hardcode.hq.registry.*;
import de.hardcode.time.Ticker;

import de.jpilot.game.Actor;
import de.jpilot.game.ActorHandler;
import de.jpilot.game.ActorListener;
import de.jpilot.hqcontrol.RemoteMovedHandler;
import de.jpilot.hqcontrol.RemotePlayerPropertyHandler;
import de.jpilot.hqcontrol.RemoteRemovedHandler;
import de.jpilot.movement.ConstantMovement;
import de.jpilot.protocol.ID;

import java.awt.Dimension;


/**
 * Static class used as a building block for a remote player.
 *
 * @author  Herkules
 */
public class RemotePlayer
{	
		
	
	/**
	 * Creates a new instance of Player
	 */
	public static void create( Client clt, Identity id )
	{
		Ship ship = new Ship( clt.getGame() );
				
		
		//
		// Listener setup
		//
		ship.addListener( new ShipGraphicListener( clt.getEngine().createGraphicObject( Engine.TYPE_SHIP ) ) );
		ship.addListener( new RemotePlayerPropertyMaintainer( id, clt.getSubSystems().getProperties() ) );
//		ship.addListener( new DebugMovementReporter() );

		
		//
		// Handler setup
		//
		Dimension mapsize = clt.getGame().getMap().getSize();
		ship.addHandler( new CoordinateWrapperHandler( mapsize.width, mapsize.height ) );
		ship.addHandler( new RemoteRemovedHandler( clt.getSubSystems().getRegistry(), id ) );
		ship.addHandler( new RemoteMovedHandler( clt.getSubSystems().getLocations(), id ) );
		ship.addHandler( new MovementHandler( new ConstantMovement() ) );
		ship.addHandler( new RemotePlayerPropertyHandler( id, clt.getSubSystems().getProperties() ) );
		ship.addHandler( clt.getEventManager().createRemoteFireHandler( id ) );
		
		//
		// Configure ship itself
		//
		ship.spawn();	
	}
	
	
}
