//**********************************************************************************************
//		(C) Copyright 2003 by Dipl. Phys. Joerg Plewe, HARDCODE Development
//		All rights reserved. Copying, modification,
//		distribution or publication without the prior written
//		consent of the author is prohibited.
//**********************************************************************************************
package de.jpilot.client;

import de.hardcode.hq.identity.Identity;
import de.hardcode.hq.objectbus.*;
import de.hardcode.time.Ticker;
import de.jpilot.game.*;
import de.jpilot.hqcontrol.BulletFiredEvent;
import de.jpilot.protocol.ID;


/**
 * Listen to events from the network. 
 *
 * @author  Herkules
 */
public class RemoteFireHandler implements ActorHandler, BusTicketListener
{
	
	private final Client		mClient;
	private final Identity		mActorID;
	private final BusStation	mBusStation;
	
	
	private MotionData mDataForBullet = null;
	private final MotionData mDecodeData = new MotionData();
	
	/**
	 * Creates a new instance of RemoteFireHandler
	 */
	public RemoteFireHandler( Client clt, Identity actorid, BusStation busstation )
	{
		mClient			= clt;
		mActorID		= actorid;
		mBusStation		= busstation;
		
		mBusStation.add( ID.PUBLIC_EVENTS, this );
	}
	
	
	/**
	 * Implement BusTicketListener.
	 */
	public void arrived( BusLine l, BusTicket t )
	{
		Identity evtid = t.getID();
		
		if ( evtid.isSameAs( ID.BULLET_FIRED ) )
		{
			Identity id = BulletFiredEvent.decode( t, mDecodeData );
			
			if ( id.isSameAs( mActorID ) )
			{
				mDecodeData.omega = LocalBullet.BULLET_ROTSPEED;
				mDataForBullet = mDecodeData;
			}
		}
		
	}

	
	/**
	 * Implement ActorHandler.
	 */
	public void close()
	{
		mBusStation.remove( ID.PUBLIC_EVENTS, this );
	}

	
	/**
	 * Implement ActorHandler.
	 */
	public void update( Actor actor, Ticker ticker)
	{
		if ( null != mDataForBullet )
		{
			// TEST TEST TEST!
			MotionData shipdata = actor.getMotionDataRef();
			mDataForBullet.x = shipdata.x;
			mDataForBullet.y = shipdata.y;
			mDataForBullet.timestamp = shipdata.timestamp;
			
			RemoteBullet.create( mClient, (Ship)actor, mDataForBullet );
			mDataForBullet = null;
		}
	}
	
}
