//**********************************************************************************************
//		(C) Copyright 2003 by Dipl. Phys. Joerg Plewe, HARDCODE Development
//		All rights reserved. Copying, modification,
//		distribution or publication without the prior written
//		consent of the author is prohibited.
//**********************************************************************************************
package de.jpilot.client;

import de.hardcode.hq.identity.Identity;
import de.jpilot.enginecontrol.BulletGraphicListener;
import de.jpilot.game.*;
import de.jpilot.graphicsengine.Engine;
import de.jpilot.hqcontrol.BulletFiredEvent;
import de.jpilot.movement.CoordinateWrapperHandler;
import java.awt.Dimension;

/**
 *
 * @author  Herkules
 */
public class RemoteBullet
{
	
	/**
	 *
	 */
	public static void create( Client clt, Ship whofired, MotionData initialpos )
	{
		Bullet bullet = new Bullet( clt.getGame(), whofired, initialpos );


		//
		// Listener setup
		//
		bullet.addListener( new BulletGraphicListener( clt.getEngine(), clt.getEngine().createGraphicObject( Engine.TYPE_BULLET ) ) );
	
		//
		// Handler setup
		//
		Dimension mapsize = clt.getGame().getMap().getSize();
		bullet.addHandler( new CoordinateWrapperHandler( mapsize.width, mapsize.height ) );
		bullet.addHandler( new BulletHitHandler( 8.0f ) );
		
	}
	
}
