//**********************************************************************************************
//		(C) Copyright 2003 by Dipl. Phys. Joerg Plewe, HARDCODE Development
//		All rights reserved. Copying, modification,
//		distribution or publication without the prior written
//		consent of the author is prohibited.
//**********************************************************************************************
package de.jpilot.client;

import de.hardcode.hq.identity.Identity;
import de.hardcode.hq.identity.NamedIdentity;
import de.jpilot.enginecontrol.LocalShipGraphicListener;
import de.jpilot.game.Bullet;
import de.jpilot.game.Ship;
import de.jpilot.graphicsengine.Engine;
import de.jpilot.movement.CoordinateWrapperHandler;
import de.jpilot.movement.DebugMovementReporter;
import de.jpilot.movement.MovementHandler;
import de.jpilot.hqcontrol.DeadReckonListener;
import de.jpilot.hqcontrol.LocalPlayerPropertyHandler;
import de.jpilot.hqcontrol.LocalPlayerPropertyMaintainer;
import de.jpilot.hqcontrol.LocalPlayerRegistryMaintainer;
import java.awt.Dimension;

/**
 *
 * @author  Herkules
 */
public class LocalPlayer
{
	private final			Client				mClient;
	private final			Ship				mShip;
	
	private					float				mEnergy			= MAX_ENERGY;
	
	private final static	float				MAX_ENERGY		= 1.0f;
	private final static	float				RECHARGE_RATE	= 0.0004f;
	
	private final			Identity			mIdentity;
	
	
	/**
	 * Creates a new instance of Player
	 */
	public LocalPlayer( Client clt )
	{
		mClient = clt;
		
		// Create my actor.
		mShip = new Ship( clt.getGame() );

		// Create a Identity. 
		// This has to be improved!!
		mIdentity = new NamedIdentity( clt.getUserInfo().name );
		
		//
		// Listener setup
		//
		mShip.addListener( new LocalShipGraphicListener( clt.getEngine().createGraphicObject( Engine.TYPE_SHIP ) ) );
		mShip.addListener( new DeadReckonListener( mIdentity, clt.getSubSystems().getLocations() ) );
		mShip.addListener( new LocalPlayerRegistryMaintainer( mIdentity, clt.getSubSystems().getRegistry() ) );
		mShip.addListener( new LocalPlayerPropertyMaintainer( mIdentity, clt.getSubSystems().getProperties() ) );
		mShip.addListener( new LocalDamageListener( this ) );
//		mShip.addListener( new DebugMovementReporter() );
	
		
		//
		// Handler setup
		//
		mShip.addHandler( new MovementHandler( new UserControlledMovement( clt.getController() ) ) );
		Dimension mapsize = clt.getGame().getMap().getSize();
		mShip.addHandler( new CoordinateWrapperHandler( mapsize.width, mapsize.height ) );
		mShip.addHandler( new EnergyRechargeHandler( this, RECHARGE_RATE, MAX_ENERGY ) ); 
		mShip.addHandler( new LocalFireHandler( this, clt.getController() ) );	
		mShip.addHandler( new LocalPlayerPropertyHandler( mIdentity, clt.getSubSystems().getProperties() ) );
		
		//
		// Configure ship itself
		//
		mShip.setName( clt.getUserInfo().name );
		mShip.placeRandom();
		mShip.spawn();
		
	}
	

	/** 
	 * Inform about my energy.
	 */
	float getEnergy()
	{
		return mEnergy;
	}
	
	
	/**
	 * Change energy by a certain amount.
	 */
	float changeEnergy( float amount )
	{
		mEnergy += amount;
		if ( mEnergy > MAX_ENERGY )
			mEnergy = MAX_ENERGY;
		return mEnergy;
	}
	
	/**
	 * Reset to default energy.
	 */
	void resetEnergy()
	{
		mEnergy = MAX_ENERGY;
	}
	
	
	/**
	 * Helper:
	 * Fire a bullet.
	 */
	void fireBullet()
	{
		LocalBullet.create( mClient, mShip, mIdentity );
		changeEnergy( -Bullet.getCost() );			
	}
	
}
