//**********************************************************************************************
//		(C) Copyright 2003 by Dipl. Phys. Joerg Plewe, HARDCODE Development
//		All rights reserved. Copying, modification,
//		distribution or publication without the prior written
//		consent of the author is prohibited.
//**********************************************************************************************
package de.jpilot.client;

import de.hardcode.time.Ticker;
import de.jpilot.game.Actor;
import de.jpilot.game.ActorHandler;
import de.jpilot.game.Bullet;
import de.jpilot.graphicsengine.Controller;

/**
 *
 * @author  Herkules
 */
public class LocalFireHandler implements ActorHandler
{
	private final	Controller				mController;
	private final	LocalPlayer				mPlayer;
		
	/**
	 * Creates a new instance of LocalFireHandler
	 */
	public LocalFireHandler( LocalPlayer player, Controller controller )
	{
		mPlayer		= player;
		mController = controller;
	}
	
	
	/**
	 * Implement ActorHandler.
	 * The actor is closing.
	 */
	public void close()
	{
	}
	
	
	/**
	 * Implement ActorHandler.
	 * Update my actor.
	 */
	public void update( Actor actor, Ticker ticker )
	{
		//
		// Handle weapon
		//
		if ( mController.isFiring() && readyForNextBullet( ticker.getTickTime() ) )
		{
			mPlayer.fireBullet();
		}
	}
	
	
	/** 
	 * Helper: Fire interval ready for next bullet?
	 */
	private boolean readyForNextBullet( long time )
	{
		return mPlayer.getEnergy() > Bullet.getCost();
	}
	
}
