//**********************************************************************************************
//		(C) Copyright 2003 by Dipl. Phys. Joerg Plewe, HARDCODE Development
//		All rights reserved. Copying, modification,
//		distribution or publication without the prior written
//		consent of the author is prohibited.
//**********************************************************************************************
package de.jpilot.client;

import de.jpilot.game.Actor;
import de.jpilot.game.Ship;
import de.jpilot.game.ShipListener;
import de.jpilot.game.cmds.SpawnShip;

/**
 * Deal with the damage applied to a ship.
 *
 * @author  Herkules
 */
public class LocalDamageListener implements ShipListener
{
	// We need a LocalPlayer as the maintainer of the current energy.
	private final LocalPlayer mPlayer;
	
	/**
	 * Creates a new instance of LocalDamageListener
	 */
	public LocalDamageListener( LocalPlayer player )
	{
		mPlayer = player;
	}
	
	public void closed( Actor actor )
	{
	}	
	
	public void damaged( Ship ship, float howmuch, Ship who )
	{
		if ( mPlayer.changeEnergy( -howmuch ) < 0.0f )
		{
			ship.die();
			ship.placeRandom();
			
			// 
			// Send respawn command.
			//
			SpawnShip cmd = new SpawnShip( ship );
			cmd.setStartTime( ship.getGame().getTicker().getTickTime() + 3000L );
			ship.getGame().getCommandQueue().add( cmd );
			
			// Notify the other side about its success.
			who.killed( ship );
		}
		
	}	
	
	public void died( Ship ship )
	{
	}
	
	public void moved( Actor actor )
	{
	}
	
	public void renamed( Ship ship )
	{
	}
	
	public void spawned( Ship ship )
	{
		mPlayer.resetEnergy();
	}
	
	public void changedStats(Ship ship)
	{
	}
		
	public void killed( Ship ship, Ship whom )
	{
	}
	
}
