//**********************************************************************************************
//		(C) Copyright 2003 by Dipl. Phys. Joerg Plewe, HARDCODE Development
//		All rights reserved. Copying, modification,
//		distribution or publication without the prior written
//		consent of the author is prohibited.
//**********************************************************************************************
package de.jpilot.client;

import de.hardcode.hq.identity.Identity;
import de.jpilot.enginecontrol.BulletGraphicListener;
import de.jpilot.game.*;
import de.jpilot.graphicsengine.Engine;
import de.jpilot.hqcontrol.BulletFiredEvent;
import de.jpilot.movement.CoordinateWrapperHandler;
import java.awt.Dimension;

/**
 *
 * @author  Herkules
 */
public class LocalBullet
{
	private final static float	BULLET_SPEED		= 0.2f;
	public final static float	BULLET_ROTSPEED		= 0.01f;

	private final static BulletFiredEvent BULLET_FIRED_EVENT = new BulletFiredEvent();
	
	/**
	 *
	 */
	public static void create( Client clt, Ship whofired, Identity ownerID )
	{
		MotionData initialpos = prepareInitialMotionData( whofired.getMotionData() );
		Bullet bullet = new Bullet( clt.getGame(), whofired, initialpos );


		//
		// Listener setup
		//
		bullet.addListener( new BulletGraphicListener( clt.getEngine(), clt.getEngine().createGraphicObject( Engine.TYPE_BULLET ) ) );
	
		//
		// Handler setup
		//
		Dimension mapsize = clt.getGame().getMap().getSize();
		bullet.addHandler( new CoordinateWrapperHandler( mapsize.width, mapsize.height ) );
		bullet.addHandler( new BulletHitHandler( 8.0f ) );

		
		
		//
		// Inform the world
		//
		BULLET_FIRED_EVENT.set( bullet, ownerID );
		clt.getEventManager().sendEvent( BULLET_FIRED_EVENT );
	}

	
	/** 
	 * Helper method that modifies a given MotionData object to the values
	 * appropriate for a fired bullet.
	 */
	private static MotionData prepareInitialMotionData( MotionData initial )
	{
		initial.vx		+= BULLET_SPEED * (float)Math.cos( initial.alpha );
		initial.vy		+= BULLET_SPEED * (float)Math.sin( initial.alpha );
		initial.omega	= BULLET_ROTSPEED;
		initial.ax		= 0.0f;
		initial.ay		= 0.0f;
		return initial;
	}
	
}
