//**********************************************************************************************
//		(C) Copyright 2003 by Dipl. Phys. Joerg Plewe, HARDCODE Development
//		All rights reserved. Copying, modification,
//		distribution or publication without the prior written
//		consent of the author is prohibited.
//**********************************************************************************************
package de.jpilot.client;

import de.hardcode.time.*;
import de.jpilot.game.Game;
import de.jpilot.graphicsengine.Engine;

/**
 *
 * @author  Herkules
 */
public class GameLoop implements TickerListener
{
	private final static long			CLOCK_RESYNC_INTERVAL = 60000L;
	
	// Timing stuff
//	private final Clock		mClock		= new SystemClock();
//	private final Ticker	mTicker		= new Ticker();
	private final Ticking	mTicking;
	
	private final Game		mGame;
	private final Engine	mEngine;
	private final BusStationBinding		mStationBinding;
	
	private long	mLastClockResync = 0;
	
	
	/**
	 * Creates a new instance of GameLoop
	 */
	public GameLoop( long interval, Game game, Engine engine, BusStationBinding stationbinding )
	{ 
		mGame = game;
		mEngine = engine;
		mStationBinding = stationbinding;

		mTicking = new TickingThread( new SystemClock(), new Ticker(), interval );
	}
	
	
	/**
	 * Creates a new instance of GameLoop using external ticking.
	 */
	public GameLoop( Ticking ticking, Game game, Engine engine, BusStationBinding stationbinding )
	{ 
		mTicking = ticking;
		mGame = game;
		mEngine = engine;
		mStationBinding = stationbinding;
	}

	
	/**
	 * Return the Clock in use, e.g. in order to adjust it.
	 */
	public Clock getClock()
	{
		return mTicking.getClock();
	}
	
	
	/**
	 * Start the gameloop.
	 */
	public void start()
	{
		mTicking.getTicker().addClockListener( this );
		mTicking.startTicking();
	}
	
	
	/**
	 * Stop the gameloop. 
	 * @see start()
	 */
	public void stop()
	{
		mStationBinding.getBusStation().flush();
		mTicking.stopTicking();
		mTicking.getTicker().removeClockListener( this );
	}
	
	
	/**
	 * Implement TickerListener.
	 */
	public void reset( Ticker ticker )
	{
		// Reset timing related data, ticker may jump next tick.
	}
	
	
	/**
	 * Implement TickerListener.
	 */
	public void tick( Ticker ticker )
	{
		if ( ( ticker.getTickTime() - mLastClockResync ) > CLOCK_RESYNC_INTERVAL )
		{
			mEngine.logMessage( "Latest ping time was " + mStationBinding.getLastPingValue() + "ms" );
			mStationBinding.resyncClock();
			mLastClockResync = ticker.getTickTime();
			Log.logger.info( "Resync clock." );
		}
		
		
		mGame.update( ticker );
		mStationBinding.getBusStation().flush();
		mEngine.render();
	}
	
}
