//**********************************************************************************************
//		(C) Copyright 2003 by Dipl. Phys. Joerg Plewe, HARDCODE Development
//		All rights reserved. Copying, modification,
//		distribution or publication without the prior written
//		consent of the author is prohibited.
//**********************************************************************************************
package de.jpilot.client;

import de.jpilot.hqcontrol.BulletFiredEvent;
import de.jpilot.hqcontrol.HQEvent;
import de.jpilot.hqcontrol.Log;
import de.hardcode.hq.identity.Identity;
import de.hardcode.hq.objectbus.BusStation;
import de.jpilot.game.Game;
import de.jpilot.protocol.ID;

/**
 *
 * @author  Herkules
 */
public class EventManager
{
	private final BusStation	mBusStation;
	private final Client		mClient;
	
	/**
	 * Creates a new instance of EventController
	 */
	public EventManager( Client clt )
	{
		mClient		= clt;
		mBusStation = clt.getBusStationBinding().getBusStation();		
	}

	
	/**
	 * Shutdown.
	 */
	public void close()
	{
		Log.logger.info( "Closing EventController" );
	}
	
	
	/**
	 * Send out an event.
	 */
	public void sendEvent( HQEvent evt )
	{
		mBusStation.broadcast( evt, null );
	}
	

	/**
	 * Convenience method creating a new RemoteFireHandler w/o having 
	 * a BusStation at hand.
	 */
	public RemoteFireHandler createRemoteFireHandler( Identity actorID )
	{
		return new RemoteFireHandler( mClient, actorID, mBusStation );
	}
		
}
