//**********************************************************************************************
//		(C) Copyright 2003 by Dipl. Phys. Joerg Plewe, HARDCODE Development
//		All rights reserved. Copying, modification,
//		distribution or publication without the prior written
//		consent of the author is prohibited.
//**********************************************************************************************
package de.jpilot.client;

import de.hardcode.time.Ticker;
import de.jpilot.game.Actor;
import de.jpilot.game.ActorHandler;


/**
 * A handler attached to an actor and thereby recharging the players energy.
 *
 * @author  Herkules
 */
public class EnergyRechargeHandler implements ActorHandler
{
	
	/** Energy/millisecond. */
	private final float mRate;
	
	private final float mMaxEnergy;
	
	private final LocalPlayer mPlayer;
	
	/**
	 * Creates a new instance of EnergyRechargeHandler
	 */
	public EnergyRechargeHandler( LocalPlayer player, float rate, float max )
	{
		mPlayer		= player;
		mRate		= rate;
		mMaxEnergy	= max;
	}
	

	/** 
	 * Implements Handler#close().
	 */
	public void close()
	{
		// Intentionally emtpy.
	}

	
	/** 
	 * Implements Handler#update().
	 */
	public void update( Actor actor, Ticker ticker )
	{
		if ( mPlayer.getEnergy() < mMaxEnergy )
		{
			float amount = Math.min( mRate * ticker.getDeltaT(), mMaxEnergy - mPlayer.getEnergy() );
			mPlayer.changeEnergy( amount );
		}
	}
	
	
}
