//**********************************************************************************************
//		(C) Copyright 2003 by Dipl. Phys. Joerg Plewe, HARDCODE Development
//		All rights reserved. Copying, modification,
//		distribution or publication without the prior written
//		consent of the author is prohibited.
//**********************************************************************************************
package de.jpilot.client;

import de.hardcode.hq.objectbus.*;
import de.jpilot.graphicsengine.Engine;
import de.jpilot.enginecontrol.GraphicObjectListener;
import de.jpilot.game.*;
import de.jpilot.graphicsengine.Controller;
import de.jpilot.graphicsengine.piccolo.PiccoloEngine;
import de.jpilot.hqcontrol.PropertyController;
import de.jpilot.hqcontrol.RegistrySetup;
import de.jpilot.protocol.SubSystems;
import java.net.InetAddress;


/**
 * Central object that brings together all of the clients subsystems.
 *
 *
 * @author  Herkules
 */
public class Client
{
	private	final	PiccoloEngine		mEngine;
	private	final	Controller			mController;
	private	final	UserInfo			mUserInfo;
	private	final	Game				mGame;

	private			PropertyController	mPropertyController;
	private			EventManager		mEventManager;
	
	private	final	GameLoop			mGameLoop;
    private final	BusStationBinding	mBusStationBinding;
	private final	SubSystems			mSubSystems;
	
	private final	RemotePlayerManager	mRemotePlayerManager;
	
	/**
	 * Creates a new instance of ClientManager.
	 */
	public Client( PiccoloEngine engine, Controller ctrl, UserInfo userinfo )
	{
		// Initializer
		mEngine			= engine;
		mController		= ctrl;
		mUserInfo		= userinfo;
		
		
		// Get a Map from somewhere
		Map map = new Map();
		
		// Create the game
		mGame = new Game( map );
		

		mSubSystems				= new SubSystems();

		RegistrySetup.initializeRegistry( mSubSystems.getRegistry() );
		
		mPropertyController		= new PropertyController( mGame, mSubSystems.getProperties() );

		mBusStationBinding		= new BusStationBinding( mSubSystems );
		
		mEventManager			= new EventManager( this );

		mRemotePlayerManager	= new RemotePlayerManager( this );
		
		//
		// Display welcome message.
		//
		mEngine.logMessage( "Welcome to JPilot 0.2!" );
		mEngine.logMessage( "Use cursor keys to steer, <space> to fire, <tab> to chat." );
		mEngine.logMessage( "Have fun and send comments to plewe@hardcode.de ." );
		
		
		// Create a max. 50FPS GameLoop.
		mGameLoop	= new GameLoop( mEngine.getTicking(), mGame, mEngine, mBusStationBinding );
	}
	

	public Game getGame()
	{
		return mGame;
	}
	
	
	public Engine getEngine()
	{
		return mEngine;
	}
	
	public Controller getController()
	{
		return mController;
	}
	
	public SubSystems getSubSystems()
	{
		return mSubSystems;
	}
	
	public UserInfo getUserInfo()
	{
		return mUserInfo;
	}
	
	public EventManager getEventManager()
	{
		return mEventManager;
	}
	
	public BusStationBinding getBusStationBinding()
	{
		return mBusStationBinding;
	}
	
	
	/**
     * Connect to server
     */
    public final boolean connect( InetAddress server, int port )
    {
		boolean connected = mBusStationBinding.connect( server, port, mGameLoop.getClock() );

		
		
		if ( connected )
		{

			mEngine.createChatInput( mUserInfo.name, mBusStationBinding.getChatClient() );
			mGameLoop.start();

			// Initiate the download of the current stuff.
			mBusStationBinding.download();
			
			//
			// TEST
			//
			new LocalPlayer( this );
		}

			
		return connected;
	}
	
	
	/**
	 * Shutdown.
	 */
	public void close()
	{
		Log.logger.info( "Closing ClientManager" );
		mGame.close();
		mGameLoop.stop();

		mRemotePlayerManager.close();
		mPropertyController.close();
		mEventManager.close();
		mBusStationBinding.close();
		mSubSystems.close();
	}
	
	
}
