//**********************************************************************************************
//		(C) Copyright 2002 by Dipl. Phys. Joerg Plewe, HARDCODE Development
//		All rights reserved. Copying, modification,
//		distribution or publication without the prior written
//		consent of the author is prohibited.
//
// Created on 5. Dezember 2002, 23:32
//**********************************************************************************************
package de.jpilot.client;

import de.hardcode.hq.chat.client.ChatClient;
import de.hardcode.hq.location.client.LocationsClient;
import de.hardcode.hq.objectbus.*;
import de.hardcode.hq.objectbus.BusStation;
import de.hardcode.hq.property.client.PropertyClient;
import de.hardcode.hq.registry.client.RegistryClient;
import de.hardcode.hq.time.client.TimeClient;
import de.hardcode.time.Clock;
import de.jpilot.protocol.*;
import de.jpilot.protocol.ID;
import de.jpilot.protocol.SubSystems;
import java.net.*;

/**
 *
 * @author  Herkules
 */
public class BusStationBinding
{
    private final RegistryClient    mRegistryClient;
    private final LocationsClient   mLocationsClient;
    private final PropertyClient	mPropertyClient;
    private final ChatClient		mChatClient;
    private		  TimeClient		mTimeClient;
    private final NetStation		mStation        = new NetStation();
	
	
    /**
     * Creates a new instance of BusStationBinding.
     */
    public BusStationBinding( SubSystems subsys )
    {
        mRegistryClient     = new RegistryClient(	mStation, ID.REGISTRY, ID.REGISTRY_SERVICE, subsys.getRegistry() );
        mLocationsClient    = new LocationsClient(	mStation, ID.LOCATIONS, ID.LOCATIONS_SERVICE, subsys.getLocations() );
        mPropertyClient     = new PropertyClient(	mStation, ID.PROPERTY, ID.PROPERTY_SERVICE, subsys.getProperties() );
        mChatClient         = new ChatClient(		mStation, ID.CHAT );
    }

	
    /**
     * Shutdown binding.
     */
    public final void close()
    {
        mRegistryClient.close();
        mLocationsClient.close();
		mPropertyClient.close();
        mChatClient.close();
		if ( null != mTimeClient )
			mTimeClient.close();
		mStation.close();
    }
    
	
	public BusStation getBusStation()
	{
		return mStation;
	}
	
    
	public ChatClient getChatClient()
	{
		return mChatClient;
	}
	
	
    /**
     * Fill the subsystems with content from the server.
     */
    public void download()
    {
        mLocationsClient.download();
        mRegistryClient.download();
        mPropertyClient.download();
    }


	/**
     * Connect to server
     */
    public final boolean connect( InetAddress server, int port, Clock clk )
    {
		long ping = Long.MAX_VALUE;
		
        NetLine line = mStation.createLine( server, port );
        if ( null != line )
        {
            mStation.startReceive();

			mTimeClient = new TimeClient( line, ID.TIME_SERVICE, clk );
			ping = mTimeClient.ping( true );
			
            // Ping the server, adjust my clock.
//            ping = TimeClient.ping( line, ID.TIME_SERVICE, clk );
            Log.logger.info( "Ping time to server is " + ping );
        }
		else
		{
			Log.logger.severe( "Cannot create line to server " + server + ":" + port );
		}
        
        return ( ping < 2000 );
    }
	
	
	/**
	 * Perform an asynchronous resync of the clock.
	 */
	public void resyncClock()
	{
		assert mTimeClient != null;
		
		if ( null != mTimeClient )
		{
			mTimeClient.ping( false );
		}
	}

	
	public long getLastPingValue()
	{
		assert mTimeClient != null;
		
		if ( null != mTimeClient )
		{
			return mTimeClient.getPing();
		}
		return 0L;
	}
}
